package com.bxm.adxcounter.facade.model;

import com.bxm.warcar.validate.annotation.ValidateNotNull;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 埋点参数-SDK<br/>
 *
 * @author kerry.jiang
 * @date 2020/5/8 17:16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class SdkCounterDTO extends AbstractCounterDTO {

    private static final long serialVersionUID = 1132577199900938728L;
    /**
     * 模块类型modelType
     * @see com.bxm.adxcounter.facade.constant.SdkMtEnum#getOriginal()
     */
    @ValidateNotNull
    private Integer mt;
    /**
     * sdk版本号，如：1.0.0
     */
    private String sdkv;
    /**
     * 广告位ID
     */
    private String tagid;
    /**
     * 第三方SDK类型
     * 1：穿山甲
     * 2：广点通
     * 3：变现猫
     */
    private String type;
    /**
     * 错误代码
     */
    private String code;
}
