package com.bxm.adxcounter.facade.model;

import java.io.Serializable;

import com.bxm.warcar.validate.annotation.ValidateNotNull;

import lombok.Data;

/**
 * SDK初始化上报信息<br/>
 *
 * @author kerry.jiang
 * @date 2020/1/11 15:54
 */
@Data
public class SdkEquipmentDTO implements Serializable {

    private static final long serialVersionUID = -1L;
    /**
     * 请求时间戳,目前不需要前端传
     */
    private Long timestamp;
            
    /**
     * IP地址
     */
    private String ip;
    /**
     * mac地址
     */
    private String mac;
    /**
     * 系统类型
     * 0：未知
     * 1：安卓
     * 2：IOS
     */
    private Integer os;
    /**
     * 系统版本号，如：5.0.0
     */
    private String osv;
    /**
     * IMEI，所属安卓
     */
    private String imei;
    /**
     * 安卓ID（androidId），所属安卓10.0以上
     */
    private String anid;
    /**
     * open device id，第三方设备唯一标识
     */
    private String odid;
    /**
     * IDFA，所属IOS
     */
    private String idfa;
    /**
     * 设备id（deviceId）
     */
    @ValidateNotNull
    private String devid;
    /**
     * 设备品牌（deviceBrand）,如：华为
     */
    private String devb;
    /**
     * 设备型号（deviceModel）,如：华为 mate 10 pro
     */
    private String devm;
    /**
     * 设备类型（deviceType）
     * 1：手机
     * 2：平板
     */
    private String devt;
    /**
     * 设备屏幕高度（screenHeight）
     */
    private Integer devsh;
    /**
     * 设备屏幕宽度（screenWidth）
     */
    private Integer devsw;
    /**
     * 内存,单位：G
     */
    private String memory;
    /**
     * 存储空间,单位：G
     */
    private String storage;
    /**
     * cpu型号（cpuModel）
     */
    private String cpum;
    /**
     * 手机网络运行商
     * 0：未知
     * 1：移动
     * 2：联通
     * 3：电信
     */
    private String isp;
    /**
     * 联网方式（netType）
     * 0:未知
     * 1:以太网
     * 2:Wifi网络
     * 3:蜂窝数据网络-2G
     * 4:蜂窝数据网络-3G
     * 5:蜂窝数据网络-4G
     * 6:蜂窝数据网络-5G
     * 7:蜂窝数据网络-未知
     */
    private String net;
    /**
     * 经度（longitude）
     */
    private String lon;
    /**
     * 纬度（latitude）
     */
    private String lat;
    
    /**
     * sdk版本号，如：1.0.0
     */
    private String sdkv;
    /**
     * 本机应用列表（appList）
     */
    private String appl;
    /**
     * APP包名(packageName)
     */
    @ValidateNotNull
    private String pkn;
    /**
     * 变现猫appid(Code)
     */
    private String appid;
}