package com.bxm.adxcounter.facade.service;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import com.bxm.adxcounter.facade.constant.Constants;
import com.bxm.adxcounter.facade.model.SdkEquipmentDTO;
import com.bxm.adxcounter.facade.model.SdkCounterDTO;

/**
 * SDK服务<br/>
 *
 * @author kerry.jiang
 * @date 2020/2/26 18:26
 */
@FeignClient(Constants.SERVER_NAME)
public interface SdkService {

    /**
     * SDK初始化<br/>
     *
     * @param sdk 初始化上报信息
     */
    @RequestMapping("/sdkService/init")
    ResponseEntity init(@RequestBody SdkEquipmentDTO sdk);

    /**
     * SDK数据监测<br/>
     *
     * @param counter
     * @return
     */
    @RequestMapping("/sdkService/counter")
    ResponseEntity counter(@RequestBody SdkCounterDTO counter);
}
