package com.bxm.adxcounter.facade.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/11/20 14:38
 */
@Data
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class PositionVo implements Serializable {


    private static final long serialVersionUID = -1676085192377065768L;
    /**
     *
     */
    private String appId;
    /**
     *
     */
    private String positonId;

    /**
     * 每天每人限推送次数
     */
    private Integer pushTimesPerPersonPerDay;

    /**
     * 推送展示停留时间，单位为秒
     */
    private Integer pushShowStayTime;

    /**
     * 推送间隔时间，单位为分钟
     */
    private Integer pushIntervalTime;

    /**
     * SDK初始化多少秒后开始推送 ，单位为秒
     */
    private Integer sdkInitIntervalTime;

    /**
     * 进程名称
     */
    private String processName;

    /**
     * 进程图标
     */
    private String processIcon;


    /**
     * 锁屏广告位id
     */
    private String lockScreenPositonId;

    /**
     * 进程名称
     */
    private String lockScreenProcessName;

    /**
     * 进程图标
     */
    private String lockScreenProcessIcon;


    /**
     * 广告样式
     * 1:双浮标+资讯/视频  1080*1920px
     */
    private Integer lockScreenAdStyle;

    /**
     * 浮标1广告位ID
     */
    private String lockScreenIconPositionId1;

    /**
     * 浮标2广告位ID
     */
    private String lockScreenIconPositionId2;

    /**
     * 资讯/视频URL
     */
    private String lockScreenUrl;


    /**
     * 每人每天限出现:次
     */
    private Integer lockScreenShowTimesPerPersonPerDay;

    /**
     * 息屏后延迟触发时间:秒
     */
    private Integer lockScreenIntervalTriggerTime;

    /**
     * 沉默期（单位：小时）
     */
    private Integer silentPeriod;
    /**
     * 用户锁屏设置（0关1开）
     */
    private Integer userLockSetup;

    /**
     * 日历广告位
     */
    private String calendarPositionId;
    /**
     * 天气广告位
     */
    private String weatherPositionId;
    /**
     * 活动广告位
     */
    private String activityPositionId;

    /**
     * 广告位配置
     */
    private List<PositionConfigVO> positionConfigVOS;
}
