package com.bxm.adxcounter.facade.service;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.bxm.adxcounter.facade.constant.Constants;
import com.bxm.adxcounter.facade.model.UserData;

/**
 * @author allen
 * @date 2020-07-17
 * @since 1.0
 */
@FeignClient(Constants.SERVER_NAME)
public interface UserFacadeService {

    /**
     * 获取用户数据
     * @param appId 应用ID
     * @param positionId 广告位id
     * @param cuids 用户自定义ID
     * @param date 日期
     * @return 统计数据
     */
    @PostMapping("/userFacadeService/getUserData")
    List<UserData> getUserData(@RequestParam("appId") String appId,
                               @RequestParam(name = "positionId", required = false) String positionId,
                               @RequestParam("cuids") String[] cuids,
                               @RequestParam("date") String date);
}
