package com.bxm.adxcounter.facade.model;

import com.bxm.warcar.validate.annotation.ValidateNotNull;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 埋点参数-SDK<br/>
 *
 * @author kerry.jiang
 * @date 2020/5/8 17:16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class SdkCounterDTO extends AbstractCounterDTO {

    private static final long serialVersionUID = 1132577199900938728L;
    /**
     * 模块类型modelType
     * @see com.bxm.adxcounter.facade.constant.SdkMtEnum#getOriginal()
     */
    @ValidateNotNull
    private Integer mt;
    /**
     * sdk版本号，如：1.0.0
     */
    private String sdkv;
    /**
     * 广告位ID
     */
    private String tagid;
    /**
     * 第三方SDK类型
     * 1：穿山甲
     * 2：广点通
     * 3：变现猫
     */
    private String type;
    /**
     * 错误代码
     */
    private String code;
    /**
     * 第三方错误代码
     */
    private String tcode;
    /**
     * 临时会话id
     */
    private String snid;
    /**
     * 轮次，并发第几轮
     * @since 3.6.0
     */
    private Integer rounds;
    /**
     * 价格,元
     * @since 3.6.0
     */
    private String price;
    /**
     * 代码位，即第三方广告位ID
     * @since 3.6.0
     */
    private String tposid;
    /**
     * 第三方sdk版本
     * @since 3.5.8
     */
    private String tsdkver;
    /**
     * 入口广告位ID
     * @since 3.7.0
     */
    private String etagid;
    /**
     * 是否缓存
     * @since 4.2.0
     */
    private Boolean isCached;
    /**
     * 是否在等待时间内
     * @since 4.2.0
     */
    private Boolean wwt;
    /**
     * 串行/并行。1：串行，2：并行
     * @since 4.2.0
     */
    private String eMode;
}
