package com.bxm.adxcounter.facade.service;

import com.bxm.adxcounter.facade.model.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import com.bxm.adxcounter.facade.constant.Constants;

/**
 * SDK服务<br/>
 *
 * @author kerry.jiang
 * @date 2020/2/26 18:26
 */
@FeignClient(Constants.SERVER_NAME)
public interface SdkService {

    /**
     * SDK初始化<br/>
     *
     * @param sdk 初始化上报信息
     */
    @RequestMapping("/sdkService/init")
    ResponseEntity<PositionVo> init(@RequestBody SdkEquipmentDTO sdk);

    /**
     * 绑定扩展参数
     * @param dto dto
     */
    @RequestMapping("/sdkService/extBind")
    void extBind(@RequestBody SdkPublicDTO dto);

    /**
     * SDK数据监测<br/>
     *
     * @param counter
     * @return
     */
    @RequestMapping("/sdkService/counter")
    ResponseEntity counter(@RequestBody SdkCounterDTO counter);

    /**
     * SDK初始化<br/>
     *
     * @param sdk 初始化获取媒体广告位等配置
     * 改方法由初始化上报改造而来
     */
    @RequestMapping("/sdkService/appConfig")
    ResponseEntity<PositionVo> appConfig(@RequestBody SdkEquipmentDTO sdk);

    /**
     * SDK获取applist方式配置
     * @param sdk
     * @return
     */
    @RequestMapping("/sdkService/appListConfig")
    ResponseEntity<AppListConfigVO> appListConfig(@RequestBody SdkEquipmentDTO sdk);
}
