package com.bxm.adxcounter.facade.constant;

/**
 * 内置统计枚举-SDK<br/>
 * 主要用于facade调用<br/>
 *
 * @author kerry.jiang
 * @date 2020/5/8 17:23
 */
public enum SdkMtEnum {

    /** 不明的 */
    _OTHER(-99, DotMtEnum._OTHER),

    //-------------------------------  ADX  --------------------------------
    /** 调度接口请求 */
    _101(101, DotMtEnum._16001),
    /** 调度接口响应 */
    _102(102, DotMtEnum._16002),
    /** sdk执行xx请求 */
    _103(103, DotMtEnum._16003),
    /** sdk执行xx请求超时 */
    _104(104, DotMtEnum._16004),
    /** 第三方广告曝光 */
    _105(105, DotMtEnum._16006),
    /** 第三方广告点击 */
    _106(106, DotMtEnum._16007),
    /** 第三方视频播放完成 */
    _107(107, DotMtEnum._16008),
    ;

    /**
     * facade MT
     */
    private int original;
    /**
     * 数据中心MT
     */
    private DotMtEnum[] dotMtEnums;

    SdkMtEnum(int original, DotMtEnum... dotMtEnums) {
        this.original = original;
        this.dotMtEnums = dotMtEnums;
    }

    public int getOriginal() {
        return original;
    }

    public DotMtEnum[] getDotMtEnums() {
        return dotMtEnums;
    }

    /**
     * 根据原值返回枚举
     * @param original 原值
     * @return 如果原值未定义，那么统一返回 {@linkplain SdkMtEnum#_OTHER _OTHER}
     */
    public static SdkMtEnum of(Integer original) {
        SdkMtEnum[] values = values();
        for (SdkMtEnum value : values) {
            if (original == value.getOriginal()) {
                return value;
            }
        }
        return _OTHER;
    }
}
