package com.bxm.app.facade;

import com.bxm.app.model.dto.AddAdvanceAppFlowRecordDto;
import com.bxm.app.model.dto.QueryAdvanceAppParamsDto;
import com.bxm.app.model.vo.AdvanceAppFlowRecordTotalVo;
import com.bxm.app.model.vo.AdvanceAppFlowRecordVo;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/9/4 14:24
 * 修 改 人：
 * 日 期：
 * 描 述： 预存媒体相关接口
 * 版 本 号： v1
 */
@FeignClient(name = "app")
public interface AdvanceAppFacadeService {

    /**
     * Description: 查询每个媒体的历史总消耗，总充值， 按appKeys 批量查找
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/30 18:08
     */
    @RequestMapping(value = "/advanceAppFacade/getAdvanceAppSumFlowRecord", method = RequestMethod.POST, consumes = "application/json")
    ResultModel<PageInfo<AdvanceAppFlowRecordTotalVo>> getAdvanceAppSumFlowRecord(@RequestBody QueryAdvanceAppParamsDto paramsDto);

    /**
     * Description: 按appKey和时间范围获取预付款的媒体资金流水数据详情
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/30 18:08
     */
    @RequestMapping(value = "/advanceAppFacade/getAdvanceAppFlowRecords", method = RequestMethod.GET)
    ResultModel<PageInfo<AdvanceAppFlowRecordVo>> getAdvanceAppFlowRecords(@RequestParam(value = "appKey") String appKey,
                                                                           @RequestParam(value = "startTime", required = false) String startTimeStr,
                                                                           @RequestParam(value = "endTime", required = false) String endTimeStr,
                                                                           @RequestParam(value = "onlyShowRechargeFlag", required = false) Integer onlyShowRechargeFlag,
                                                                           @RequestParam(value = "pageNum", required = false) Integer pageNum,
                                                                           @RequestParam(value = "pageSize", required = false) Integer pageSize);

    /**
     * Description: 给预存媒体增加充值记录
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/9/3 10:04
     */
    @RequestMapping(value = "/advanceAppFacade/addRechargeRecord", method = RequestMethod.POST, consumes = "application/json")
    ResultModel<Boolean> addRechargeRecord(@RequestBody AddAdvanceAppFlowRecordDto appFlowRecordDto);
}
