/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.app.facade;

import com.bxm.app.model.dto.AppEntranceAdDto;
import com.bxm.app.model.dto.AuditAdPositionDto;
import com.bxm.app.model.dto.QueryAppAdPositionDto;
import com.bxm.app.model.dto.common.QueryAppEntranceParamDTO;
import com.bxm.app.model.dto.params.adsmanager.QueryAppEntranceByMinOnlineTimeParamDTO;
import com.bxm.app.model.ro.AppEntranceAdRo;
import com.bxm.app.model.vo.AppEntranceCountByAppKeyVO;
import com.bxm.app.model.vo.AppEntranceMinOnlineTimeByAppKeyVO;
import com.bxm.app.model.vo.QueryPositionIdAndNameVo;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @ClassName AppEntranceFacadeService.java
 * @Description 功能描述：广告位相关接口
 * @author leon 2018年3月12日 下午3:26:23
 * @CopyRight 杭州微财网络科技有限公司
 */
@FeignClient(name = "app")
public interface AppEntranceFacadeService {

    /**
     * @Description 方法描述：修改开发者广告位相关信息，修改备注，别名，行业类型
     * @author leon 2018年3月12日 下午4:20:18
     * @CopyRight 杭州微财网络科技有限公司
     * @param appEntranceDto
     * @return
     * @throws ValidateException
     * @throws Exception
     */
    @RequestMapping(value = "/appEntranceFacade/updateAdPositionInfo", method = RequestMethod.PUT)
    public ResultModel<Boolean> updateAdPositionInfo(@RequestBody AppEntranceAdDto appEntranceDto) throws ValidateException,
                                                                                                   Exception;

    /**
     * @Description 方法描述：根据positionId查询广告位信息，返回开发者名称,行业类型,备注,别名等信息
     * @author leon 2018年3月12日 下午4:20:45
     * @CopyRight 杭州微财网络科技有限公司
     * @param positionId
     * @return
     * @throws ValidateException
     * @throws Exception
     */
    @RequestMapping(value = "/appEntranceFacade/getByPositionId", method = RequestMethod.GET)
    public ResultModel<AppEntranceAdRo> getByPositionId(@RequestParam(value = "positionId", required = true) String positionId) throws ValidateException,
                                                                                                                                Exception;

    /**
     * @Description 方法描述：根据关键字查询列表，默认查询全部
     * @author leon 2018年3月12日 下午4:21:09
     * @CopyRight 杭州微财网络科技有限公司
     * @param positionId 广告位id
     * @param keywords 关键字：BD,媒介,备注
     * @return
     * @throws ValidateException
     * @throws Exception
     */
    @RequestMapping(value = "/appEntranceFacade/getList", method = RequestMethod.GET)
    public ResultModel<List<AppEntranceAdRo>> getList(@RequestParam(value = "positionId", required = false) String positionId,
                                                      @RequestParam(value = "keyword", required = false) String keywords) throws ValidateException,
                                                                                                                          Exception;

    /**
     * @Description 方法描述：查询审核列表
     * @author leon 2018年4月2日 下午3:35:32
     * @CopyRight 杭州微财网络科技有限公司
     * @param pageNum
     * @param pageSize
     * @param positionId
     * @param keywords
     * @param state
     * @return
     * @throws ValidateException
     * @throws Exception
     */
    @RequestMapping(value = "/appEntranceFacade/getAuditList", method = RequestMethod.GET)
    public ResultModel<PageInfo<AppEntranceAdRo>> getAuditList(@RequestParam(value = "pageNum", required = true) Integer pageNum,
                                                               @RequestParam(value = "pageSize", required = true) Integer pageSize,
                                                               @RequestParam(value = "positionId", required = false) String positionId,
                                                               @RequestParam(value = "keyword", required = false) String keywords,
                                                               @RequestParam(value = "state", required = false) Integer state) throws ValidateException,
                                                                                                                               Exception;

    /**
     * @Description 方法描述：审核广告位信息
     * @author leon 2018年4月2日 下午3:56:34
     * @CopyRight 杭州微财网络科技有限公司
     * @param auditAdPositionDto
     * @return
     * @throws ValidateException
     * @throws Exception
     */
    @RequestMapping(value = "/appEntranceFacade/auditAdPosition", method = RequestMethod.PUT)
    public ResultModel<Boolean> auditAdPosition(@RequestBody AuditAdPositionDto auditAdPositionDto) throws ValidateException,
                                                                                                    Exception;

    /**
     *
     * @CopyRright  (c) 2018-微财科技有限公司
     * @author sunzhongshu
     * @created 2018/6/4 15:18
     * @modifier sunzhongshu
     */

    @ApiOperation(value = "不分页根据单个媒体下面的广告位列表",notes = "不分页根据单个媒体下面的广告位列表")
    @RequestMapping(value = "/appEntranceFacade/getPositionIdList",method = RequestMethod.GET)
    public ResultModel<List<AppEntranceAdRo>> getPositionIdList(@RequestParam(value = "state", required = false) Integer state,
                                                                @RequestParam(value = "appKey",required = true) String appKey) throws ValidateException,Exception;

    /**
     * 查询对接方式, 0为h5
     * @param appKey
     * @param appEntranceId
     * @return
     */
    @RequestMapping(value = "/appEntranceFacade/queryDockMethod", method = RequestMethod.GET)
    ResultModel<Integer> queryDockMethod(@RequestParam("appKey") String appKey, @RequestParam("appEntranceId") String appEntranceId);

    //通过app_entrance主键来查广告位ID
	@RequestMapping(value = "/appEntranceFacade/getPositionIdsByIds", method = RequestMethod.GET)
	public   ResultModel<List<String>>  getPositionIdsByIds(@RequestParam(value = "ids",required = true)String ids);


	/**
	 * Description: 查询广告位ID和名称，用于adsreportor的下拉框数据填充
	 * JDK version used: <JDK1.8>
	 * Author： hxpeng
	 * Create Date： 2018/8/22 10:29
	 */
    @ApiOperation(value = "根据APP KEY 或 id 或 名称查询广告位列表",notes = "根据APP KEY 或 id 或 名称查询广告位列表")
    @RequestMapping(value = "/appEntranceFacade/getPositionIdAndName", method = RequestMethod.GET)
    ResultModel<List<QueryPositionIdAndNameVo>> getPositionIdAndName(@RequestParam(value = "keyWords") String keyWords,
                                                                     @RequestParam(value = "appKey", required = false) String appKey);

    /**
     * Description: 根据positionID(appKey_entranceId) 集合 批量获取广告位列表
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/22 10:29
     */
    @RequestMapping(value = "/appEntranceFacade/getListByPositionIds", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<AppEntranceAdRo>> getListByPositionIds(String jsonString);

    /**
    * @Title: getPositionList
    * @Description: 通过媒介、广告位名等参数查询广告位列表数据
    * @param QueryAppAdPositionDto
    * @return ResultModel<List<AppEntranceAdRo>>
     */
    @RequestMapping(value = "/appEntranceFacade/getPositionList", method = RequestMethod.POST, consumes="application/json")
    public ResultModel<List<AppEntranceAdRo>> getPositionList(@RequestBody QueryAppAdPositionDto appAdPositionDto);

    /**
     *
     * 功能描述:
     * @fileName:根据状态获取广告链接列表
     * @param:
     * @return:
     * @auther: sunzs
     * @date: 2018/10/22 19:20
     */
    @RequestMapping(value = "/appEntranceFacade/getListByState", method = RequestMethod.GET)
    public ResultModel<List<AppEntranceAdRo>> getListByState(@RequestParam("state")Integer state);


    /**
     * Description: 根据APP KEY 和 KEYWORDS(广告位名称ID)
     * JDK version used:<JDK1.8>
     * Create Date：2018/11/1 14:18

     * @param paramDTO 搜索条件
     * @return com.bxm.util.dto.ResultModel<java.util.List<com.bxm.app.model.ro.AppEntranceAdRo>>
     * @author hxpeng
     */
    @RequestMapping(value = "/appEntranceFacade/getListByAppKeyAndKeywords", method = RequestMethod.POST, consumes="application/json")
    ResultModel<PageInfo<AppEntranceAdRo>> getListByAppKeyAndKeywords(@RequestBody QueryAppEntranceParamDTO paramDTO);


    /**
     * Description: 多少通用一点的 广告位查询接口
     * JDK version used:<JDK1.8>
     * Create Date：2018/11/2 10:52

     * @param paramDTO 查询条件
     * @return com.github.pagehelper.PageInfo<com.bxm.app.model.ro.AppEntranceAdRo>
     * @author hxpeng
     */
    @RequestMapping(value = "/appEntranceFacade/common/getListByParam", method = RequestMethod.POST, consumes="application/json")
    ResultModel<PageInfo<AppEntranceAdRo>> getListByParam(@RequestBody QueryAppEntranceParamDTO paramDTO);

    /**
     * Description: 根据APP名称精确或模糊查询， 广告位列表
     * JDK version used:<JDK1.8>
     * Create Date：2018/11/5 17:53

     * @param appName app名称
     * @param fuzzyFlag 是否需要模糊查询 1:Y,0:N
     * @return com.bxm.util.dto.ResultModel<java.util.List<com.bxm.app.model.ro.AppEntranceAdRo>>
     * @author hxpeng
     */
    @RequestMapping(value = "/appEntranceFacade/common/getAllByAppName", method = RequestMethod.GET)
    ResultModel<List<AppEntranceAdRo>> getAllByAppName(@RequestParam(name = "appName") String appName,
                                                       @RequestParam(name = "fuzzyFlag", defaultValue = "0") Integer fuzzyFlag);

    /**
     * Description: 根据APP KEY集合批量查询各个appkey下的所拥有的广告位个数
     * * JDK version used:<JDK1.8>
     * JDK version used:<JDK1.8>
     * Create Date：2018/11/7 10:36
     *
     * @param appKeysJSONStr appKey集合json字符串
     * @return com.bxm.util.dto.ResultModel<java.util.List<com.bxm.app.model.vo.AppEntranceCountByAppKeyVO>>
     * @author hxpeng
     */
    @RequestMapping(value = "/appEntranceFacade/common/getAppEntranceCountGroupByAppKeys", method = RequestMethod.POST, consumes = "application/json")
    ResultModel<List<AppEntranceCountByAppKeyVO>> getAppEntranceCountGroupByAppKeys(String appKeysJSONStr);

    /**
     * Description: 根据APP KEY集合批量分组查询各个appkey下的广告位的最早的上线时间
     * JDK version used:<JDK1.8>
     * Create Date：2018/11/7 14:00

     * @param paramDTO 查询条件
     * @return com.bxm.util.dto.ResultModel<java.util.List<com.bxm.app.model.vo.AppEntranceMinOnlineTimeByAppKeyVO>>
     * @author hxpeng
     */
    @RequestMapping(value = "/appEntranceFacade/common/getAppEntranceMinOnlineTimeGroupByAppKey", method = RequestMethod.POST, consumes = "application/json")
    ResultModel<List<AppEntranceMinOnlineTimeByAppKeyVO>> getAppEntranceMinOnlineTimeGroupByAppKey(@RequestBody QueryAppEntranceByMinOnlineTimeParamDTO paramDTO);

    /**
     *
     * 功能描述:
     * @fileName:查询广告位基本信息带分页
     * @param: [appAdPositionDto]
     * @return: com.github.pagehelper.PageInfo<com.bxm.app.model.ro.AppEntranceAdRo>
     * @auther: sunzs
     * @date: 2018/11/21 16:55
     */
    @RequestMapping(value = "/appEntranceFacade/getPositionListPage",method = RequestMethod.POST, consumes="application/json")
    ResultModel<PageInfo<AppEntranceAdRo>> getPositionListPage(@RequestBody QueryAppAdPositionDto appAdPositionDto);
    
    /**
     * @Title: getPositionIdListByParam  
     * @Description: 查询广告平台的广告位ID的集合
     * @param QueryAppEntranceParamDTO paramDTO
     * @return ResultModel<List<String>> 
      */
     @RequestMapping(value = "/appEntranceFacade/common/getPositionIdListByParam", method = RequestMethod.POST, consumes = "application/json")
     ResultModel<List<String>> getPositionIdListByParam(@RequestBody QueryAppEntranceParamDTO paramDTO);
}
