package com.bxm.app.facade;

import java.util.List;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import com.bxm.app.model.dto.PositionClassTypeDto;
import com.bxm.app.model.ro.PositionClassType;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;

/**
* @Title:MediaCommonConfigFacadeService.java
* @Package:com.bxm.app.facade
* @Description: 媒体相关配置接口
 */
@FeignClient(name = "app")
public interface MediaCommonConfigFacadeService {

    /**
     * @Title: queryPositionClassTypeList  
     * @Description: 查询媒体相关配置列表
     * @param PositionClassTypeDto
     * @return ResultModel<List<PositionClassType>> 
      */
    @RequestMapping(value = "/mediaConfigFacade/mediaConfigList", method = RequestMethod.POST)
    ResultModel<List<PositionClassType>> queryPositionClassTypeList(@RequestBody PositionClassTypeDto positionClassTypeDto);
    
    /**
     * @Title: queryPositionClassTypePageList  
     * @Description: 查询媒体相关配置列表(分页)
     * @param PositionClassTypeDto
     * @return ResultModel<PageInfo<PositionClassType>> 
      */
    @RequestMapping(value = "/mediaConfigFacade/mediaConfigPageList", method = RequestMethod.POST)
    ResultModel<PageInfo<PositionClassType>> queryPositionClassTypePageList(@RequestBody PositionClassTypeDto positionClassTypeDto);

    /**
     * @Title: getPositionClassTypeById  
     * @Description:根据主键查询媒体配置信息 
     * @param 主键ID
     * @return ResultModel<PositionClassType> 
      */
    @RequestMapping(value = "/mediaConfigFacade/getById", method = RequestMethod.GET)
    ResultModel<PositionClassType> getPositionClassTypeById(@RequestParam(value = "id") Long id);

    /**
      * @Title: updatePositionClassTypeById  
      * @Description:根据主键更新媒体配置信息 
      * @param PositionClassType
      * @return ResultModel<Boolean> 
       */
    @RequestMapping(value = "/mediaConfigFacade/media/config", method = RequestMethod.PUT)
    ResultModel<Boolean> updatePositionClassTypeById(@RequestBody PositionClassType positionClassType);

    /**
     * @Title: addPositionClassType  
     * @Description: 新增媒体配置信息
     * @param PositionClassType
     * @return ResultModel<Boolean> 
      */
    @RequestMapping(value = "/mediaConfigFacade/media/config", method = RequestMethod.POST)
    ResultModel<Boolean> addPositionClassType(@RequestBody PositionClassType positionClassType);

    /**
     * @Title: delPositionClassTypeById  
     * @Description:根据主键ID删除媒体配置信息
     * @param 主键ID
     * @param typeCode 标签码
     * @return ResultModel<Boolean> 
      */
    @RequestMapping(value = "/mediaConfigFacade/delById", method = RequestMethod.DELETE)
    ResultModel<Boolean> delPositionClassTypeById(@RequestParam(value = "id") Long id,
            @RequestParam(value = "typeCode") String typeCode);
}
