package com.bxm.app.facade;

import com.bxm.app.model.dto.ProviderAppAdDto;
import com.bxm.app.model.dto.UpdateProviderAppParamDTO;
import com.bxm.app.model.ro.ProviderAppAdRo;
import com.bxm.util.dto.ResultModel;

import java.util.List;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * Description 开发者媒体通用接口
 *
 * @author hxpeng
 * <p>
 * Date 2018/10/30 11:36
 */
@FeignClient(name = "app")
public interface ProviderAppCommonFacadeService {

    /**
     * Description: （运营后台）修改开发者信息接口
     * JDK version used:<JDK1.8>
     * Create Date：2018/10/30 14:36

     * @param paramDTO 修改参数
     * @return java.lang.Boolean
     * @author hxpeng
     */
    @RequestMapping(value = "/providerAppFacade/common/updateProviderApp", method = RequestMethod.POST, consumes = "application/json")
    ResultModel<Boolean> updateProviderApp(@RequestBody UpdateProviderAppParamDTO paramDTO);

    /**
     * @Title: getAppList  
     * @Description: 根据参数查询媒体列表信息
     * @param ProviderAppAdDto
     * @return ResultModel<List<ProviderAppAdRo>> 
      */
    @RequestMapping(value = "/providerAppFacade/common/getAppList", method = RequestMethod.POST, consumes = "application/json")
    ResultModel<List<ProviderAppAdRo>> getAppList(@RequestBody ProviderAppAdDto providerAppAdDto);
    
    /**
     * @Title: getAppKeyList  
     * @Description: 根据参数查询媒体appKey的集合
     * @param ProviderAppAdDto
     * @return ResultModel<List<String>> 
      */
    @RequestMapping(value = "/providerAppFacade/common/getAppKeyList", method = RequestMethod.POST, consumes = "application/json")
    ResultModel<List<String>> getAppKeyList(@RequestBody ProviderAppAdDto providerAppAdDto);
    
    /**
     * @Title: getAppInfoByAppKey  
     * @Description: 根据appKe查询媒体详细信息
     * @param appKey
     * @return ResultModel<ProviderAppAdRo> 
      */
    @RequestMapping(value = "/providerAppFacade/common/getByAppKey", method = RequestMethod.GET)
    ResultModel<ProviderAppAdRo> getAppInfoByAppKey(@RequestParam(value = "appKey", required = true) String appKey);


}
