/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.app.facade;

import java.util.List;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bxm.app.model.dto.ProviderAppAdDto;
import com.bxm.app.model.ro.ProviderAppAdRo;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;

/**
 * @ClassName ProviderAppFacadeService.java
 * @Description 功能描述：app
 * @author leon 2017年10月19日 下午5:23:18
 * @CopyRight 杭州微财网络科技有限公司
 */
@FeignClient(name = "app")
public interface ProviderAppFacadeService {

    /**
     * @Description 方法描述：修改app，修改开发者广告相关信息
     * @author leon 2018年3月12日 下午4:19:53
     * @CopyRight 杭州微财网络科技有限公司
     * @param providerAppAdDto
     * @return
     * @throws ValidateException
     * @throws Exception
     */
    @RequestMapping(value = "/providerAppFacade/updateProviderAppAdInfo", method = RequestMethod.PUT)
    public ResultModel<Boolean> updateProviderAppAdInfo(@RequestBody ProviderAppAdDto providerAppAdDto) throws ValidateException,
                                                                                                        Exception;

    /**
     * @Description 方法描述：根据appId获取app详细信息：返回开发者名称，BD,媒介,备注
     * @author leon 2018年3月12日 下午4:19:33
     * @CopyRight 杭州微财网络科技有限公司
     * @param id
     * @return
     * @throws ValidateException
     * @throws Exception
     */
    @RequestMapping(value = "/providerAppFacade/getById", method = RequestMethod.GET)
    public ResultModel<ProviderAppAdRo> getById(@RequestParam(value = "id", required = true) Long id) throws ValidateException,
                                                                                                      Exception;

    /**
     * @Description 方法描述：根据关键字查询app列表
     * @author leon 2018年3月12日 下午4:18:29
     * @CopyRight 杭州微财网络科技有限公司
     * @param keywords 关键字：appName,别名,媒介,备注
     * @return
     * @throws ValidateException
     * @throws Exception
     */
    @RequestMapping(value = "/providerAppFacade/getList", method = RequestMethod.GET)
    public ResultModel<List<ProviderAppAdRo>> getList(@RequestParam(value = "keywords", required = false) String keywords) throws ValidateException,
                                                                                                                           Exception;
}
