package com.bxm.app.model.dto;

import com.bxm.app.model.constant.Constant;

public class QueryAppAdPositionConfigDto {

    /**
     * 页码，默认1
     */
    private Integer pageNum  = Constant.DEFAULT_PAGE_NUM;

    /**
     * 每页数量，默认10，最大10
     */
    private Integer pageSize = Constant.DEFAULT_PAGE_SIZE;

    /**
     * 主键id
     */
    private Long    id;

    /**
     * 产品id：8福利社，9积分商城
     */
    private Integer productId;

    /**
     * app开发者appId
     */
    private Integer appId;

    /**
     * app开发者appKey
     */
    private String  appKey;

    /**
     * 变现猫媒体开发者appKey
     */
    private String  bxmMediaAppKey;

    /**
     * 资源位名称
     */
    private String  resPositionName;

    /**
     * 广告位id
     */
    private String  adPositionId;

    /**
     * @return the pageNum
     */
    public Integer getPageNum() {
        return pageNum;
    }

    /**
     * @param page the pageNum to set
     */
    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum == null ? Constant.DEFAULT_PAGE_NUM : pageNum;
    }

    /**
     * @return the pageSize
     */
    public Integer getPageSize() {
        return pageSize;
    }

    /**
     * @param pageSize the pageSize to set
     */
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize == null ? Constant.DEFAULT_PAGE_SIZE : pageSize;
        if (this.pageSize > Constant.DEFAULT_MAX_PAGE_SIZE) {
            this.pageSize = Constant.DEFAULT_MAX_PAGE_SIZE;
        }
    }

    /**
     * 主键id
     * 
     * @return id 主键id
     */
    public Long getId() {
        return id;
    }

    /**
     * 主键id
     * 
     * @param id 主键id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 产品id：8福利社，9积分商城
     * 
     * @return product_id 产品id：8福利社，9积分商城
     */
    public Integer getProductId() {
        return productId;
    }

    /**
     * 产品id：8福利社，9积分商城
     * 
     * @param productId 产品id：8福利社，9积分商城
     */
    public void setProductId(Integer productId) {
        this.productId = productId;
    }

    /**
     * app开发者appId
     * 
     * @return app_id app开发者appId
     */
    public Integer getAppId() {
        return appId;
    }

    /**
     * app开发者appId
     * 
     * @param appId app开发者appId
     */
    public void setAppId(Integer appId) {
        this.appId = appId;
    }

    /**
     * 资源位名称
     * 
     * @return res_position_name 资源位名称
     */
    public String getResPositionName() {
        return resPositionName;
    }

    /**
     * 资源位名称
     * 
     * @param resPositionName 资源位名称
     */
    public void setResPositionName(String resPositionName) {
        this.resPositionName = resPositionName == null ? null : resPositionName.trim();
    }

    /**
     * 广告位id
     * 
     * @return ad_position_id 广告位id
     */
    public String getAdPositionId() {
        return adPositionId;
    }

    /**
     * 广告位id
     * 
     * @param adPositionId 广告位id
     */
    public void setAdPositionId(String adPositionId) {
        this.adPositionId = adPositionId == null ? null : adPositionId.trim();
    }

    /**
     * @return the bxmMediaAppKey
     */
    public String getBxmMediaAppKey() {
        return bxmMediaAppKey;
    }

    /**
     * @param bxmMediaAppKey the bxmMediaAppKey to set
     */
    public void setBxmMediaAppKey(String bxmMediaAppKey) {
        this.bxmMediaAppKey = bxmMediaAppKey;
    }

    /**
     * @return the appKey
     */
    public String getAppKey() {
        return appKey;
    }

    /**
     * @param appKey the appKey to set
     */
    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

}
