/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.app.model.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 类PayChannelEnum.java的实现描述：支付渠道
 * 
 * @author leon 2017年5月18日 上午11:54:35
 */
public enum PayChannelEnum {

                            /**
                             * 积分或者余额支付
                             */
                            JI_FEN_PAY(0, "积分或者余额支付"),
                            /**
                             * 支付宝支付
                             */
                            ALI_PAY(1, "支付宝支付"),
                            /**
                             * 微信支付
                             */
                            WECHAT_PAY(2, "微信支付"),
                            /**
                             * 银联支付
                             */
                            UNION_PAY(3, "银联支付"),
                            /**
                             * 翼支付
                             */
                            BEST_PAY(4, "翼支付");

    private int    code;

    private String name;

    /**
     * @param code
     * @param name
     */
    private PayChannelEnum(int code, String name){
        this.code = code;
        this.name = name;
    }

    /**
     * @return the code
     */
    public int getCode() {
        return code;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * 所有状态
     * 
     * @return
     */
    public static Map<Integer, String> getAllState() {
        PayChannelEnum[] sts = PayChannelEnum.values();
        Map<Integer, String> maps = new HashMap<Integer, String>();
        for (PayChannelEnum tmp : sts) {
            maps.put(tmp.code, tmp.name);
        }
        return maps;
    }

    /**
     * 根据code得到name
     * 
     * @param code
     * @return
     */
    public static String getName(int code) {
        for (PayChannelEnum state : PayChannelEnum.values()) {
            if (state.getCode() == code) {
                return state.getName();
            }
        }
        return "状态异常";
    }

}
