package com.bxm.app.model.ro;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "开发者广告系统相关字段")
public class ProviderAppAdRo {

    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long   id;

    /**
     * app名称
     */
    @ApiModelProperty(value = "app名称")
    private String appName;

    /**
     * app_key
     */
    @ApiModelProperty(value = "appKey")
    private String appKey;

    /**
     * 媒介
     */
    @ApiModelProperty(value = "媒介")
    private String medium;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 别名
     */
    @ApiModelProperty(value = "别名")
    private String alias;
    /**
     * 帐户预付类型：0 非预付，1 预付
     */
    @ApiModelProperty(value = "预付类型：0 非预付;1 预付")
    private short advanceType;

    /**
     * @return advanceType 预付类型：0 非预付;1 预付
     */
    public short getAdvanceType() {
        return advanceType;
    }

    /**
     * @param advanceType 预付类型：0 非预付;1 预付
     */
    public void setAdvanceType(short advanceType) {
        this.advanceType = advanceType;
    }

    /**
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return the appName
     */
    public String getAppName() {
        return appName;
    }

    /**
     * @param appName the appName to set
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * @return the appKey
     */
    public String getAppKey() {
        return appKey;
    }

    /**
     * @param appKey the appKey to set
     */
    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    /**
     * @return the medium
     */
    public String getMedium() {
        return medium;
    }

    /**
     * @param medium the medium to set
     */
    public void setMedium(String medium) {
        this.medium = medium;
    }

    /**
     * @return the remark
     */
    public String getRemark() {
        return remark;
    }

    /**
     * @param remark the remark to set
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * @return the alias
     */
    public String getAlias() {
        return alias;
    }

    /**
     * @param alias the alias to set
     */
    public void setAlias(String alias) {
        this.alias = alias;
    }

}
