package com.bxm.app.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/8/22 10:23
 * 修 改 人：
 * 日 期：
 * 描 述： 查询广告位的名称和ID， 用于adsreportor的下拉框数据填充
 * 版 本 号： v1
 */
@ApiModel(description = "查询广告位的名称和ID,用于adsreportor的下拉框数据填充")
public class QueryPositionIdAndNameVo implements Serializable {
    private static final long serialVersionUID = 5236415212017069267L;

    /**
     * 广告位ID 和 广告位名称
     */
    @ApiModelProperty(value = "positionId")
    private String positionId;
    @ApiModelProperty(value = "positionName")
    private String positionName;

    /**
     * 当app_entrance_name is null, 取 remark
     */
    private String remark;

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getPositionName() {
        return positionName;
    }

    public void setPositionName(String positionName) {
        this.positionName = positionName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        if (null == positionName || "".equals(positionName)) {
            if (null != remark && !"".equals(remark)) {
                this.positionName = remark;
            }
        }
    }
}
