package com.bxm.app.model.dto;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "开发者广告系统相关字段")
public class ProviderAppAdDto {

    /**
     * id
     */
    @ApiModelProperty(value = "id", required = true)
    private Long   id;
    
    /**
     * 应用名称或者媒体名称
     */
    @ApiModelProperty(value = "应用名称或者媒体名称")
    private String appName;
    
    /**
     * 媒介code
     */
    @ApiModelProperty(value = "媒介code")
    private String medium;
    
    /**
     * 商务code
     */
    @ApiModelProperty(value = "商务code")
    private String bd;
    
    /**
     * 媒介code或者商务code
     */
    @ApiModelProperty(value = "商务code或者媒介code")
    private String roleCode;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 别名
     */
    @ApiModelProperty(value = "别名")
    private String alias;

    @ApiModelProperty(value = "是否预付")
    private Integer advanceType;

    @ApiModelProperty(value = "APPKEY")
    private String appKey;
    
    @ApiModelProperty(value = "账号类型(代理、直客)")
    private Integer accountType;
    
    @ApiModelProperty(value = "appKey的List集合")
    private List<String> appKeys;
    
    @ApiModelProperty(value = "排除的appKey的List集合")
    private List<String> excludeAppKeys;
    
    @ApiModelProperty(value = "appName或者appKey")
    private String keywords;
    
    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public Integer getAdvanceType() {
        return advanceType;
    }

    public void setAdvanceType(Integer advanceType) {
        this.advanceType = advanceType;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getMedium() {
        return medium;
    }

    public void setMedium(String medium) {
        this.medium = medium;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public List<String> getAppKeys() {
        return appKeys;
    }

    public void setAppKeys(List<String> appKeys) {
        this.appKeys = appKeys;
    }

    public String getAppName() {
        return appName;
    }
    
    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getBd() {
        return bd;
    }

    public void setBd(String bd) {
        this.bd = bd;
    }

    public List<String> getExcludeAppKeys() {
        return excludeAppKeys;
    }

    public void setExcludeAppKeys(List<String> excludeAppKeys) {
        this.excludeAppKeys = excludeAppKeys;
    }

    public String getRoleCode() {
        return roleCode;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }
    
    
}
