package com.bxm.app.model.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * Description 运营后台 修改广告位
 *
 * @author hxpeng
 * <p>
 * Date 2018/10/30 14:05
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder(toBuilder = true)
@Data
public class UpdateProviderAppParamDTO implements Serializable {

    private static final long serialVersionUID = -2023155605651926730L;

    /**
     * app key
     */
    private String appKey;

    /**
     * app 别名
     */
    private String appAlias;

    /**
     * 媒介CODE
     */
    private String mjCode;

    /**
     * 销售/商务 CODE
     */
    private String saleCode;

    /**
     * 是否预付媒体（TRUE:是, FALSE:不是）
     */
    private Boolean advanceFlag;

    /**
     * 账号类型（0：直客， 1：代理， 2：子账号）
     */
    private Integer accountType;

    /**
     * 备注
     */
    private String remark;

    /**
     * 修改者
     */
    private Long modifier;

    @Override
    public String toString() {
        return "UpdateProviderAppParamDTO{" +
                "appKey='" + appKey + '\'' +
                ", appAlias='" + appAlias + '\'' +
                ", mjCode='" + mjCode + '\'' +
                ", saleCode='" + saleCode + '\'' +
                ", advanceFlag=" + advanceFlag +
                ", modifier=" + modifier +
                '}';
    }
}
