package com.bxm.app.model.dto.common;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * Description 查询开发者的广告位列表的 参数类
 *
 * @author hxpeng
 * <p>
 * Date 2018/11/1 15:32
 */
@Data
public class QueryAppEntranceParamDTO implements Serializable {
    private static final long serialVersionUID = -4391160504743951577L;

    /**
     * 广告位状态(构造器默认赋值state = 1，查询审核过的)
     * state = '', 0：审核中，1：已通过，2：已拒绝
     */
    private Integer state;

    /**
     * APPKEY
     * app_key = ''
     */
    private String appKey;
    /**
     * 模糊 appKey
     * app_key like ''
     */
    private String fuzzyAppKey;

    /**
     * 媒体名称
     * app_name = ''
     */
    private String appName;
    /**
     * 模糊 媒体名称
     * app_key like ''
     */
    private String fuzzyAppName;

    /**
     * 广告位名称
     * app_entrance_name = ''
     */
    private String appEntranceName;

    /**
     * 广告位名称 模糊
     * app_entrance_name like ''
     */
    private String fuzzyAppEntranceName;

    /**
     * 根据appKey or appName 模糊查询
     * (app_key like '' or app_name like '')
     */
    private String appKeyOrNameKeywords;

    /**
     * 根据appKey or appEntranceName 模糊查询
     * (app_key = '' or app_entrance_name like '')
     */
    private String appKeyOrFuzzyAppEntranceNameKeywords;

    /**
     * 根据positionId 和 appEntranceName模糊查询
     * (position_id = '' or app_entrance_name like '')
     */
    private String positionIdOrFuzzyAppEntranceNameKeywords;

    /**
     * 根据媒体名称 或 ID 模糊查询
     * (app_entrance_id = '' or app_entrance_name like '')
     */
    private String keywords;

    /**
     * 媒介
     * medium = ""
     */
    private String mjCode;

    /**
     * 上线时间范围查询--开始
     */
    private String onlineTimeStart;

    /**
     * 上线时间范围查询--结束
     */
    private String onlineTimeEnd;

    /**
     * 主键
     * id in ()
     */
    private List<Long> ids;

    /**
     * 主键
     * id not in ()
     */
    private List<Long> notInIds;

    /**
     * 广告位ID
     * position_id in ()
     */
    private List<String> positionIds;

    /**
     * appKey 集合
     * app_key in ()
     */
    private List<String> appKeys;

    /**
     * appEntranceId 集合
     * app_entrance_id in ()
     */
    private List<String> appEntranceIds;

    /**
     * 分页
     */
    private Integer pageNum;
    private Integer pageSize;

    /**
     * 排序
     */
    private String sortField;
    private String orderType;
    
    /**
     * 广告位ID精确或者媒体名称模糊或者appEntranceId精确
     */
    private String positionIdOrFuzzyAppNameOrAppEntranceIdKeywords;
    
    /**
     * 广告位ID精确或者appKey模糊或者媒体名称模糊或者广告位名称模糊
     */
    private String positionIdOrFuzzyAppKeyOrFuzzyTwoName;


    public QueryAppEntranceParamDTO() {
        this.pageNum = 1;
        this.pageSize = 20;
        this.state = 1;
    }


}
