package com.bxm.app.model.dto.params.adsmanager;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;

/**
 * Description 运营后台 查询 开发者媒体 请求参数 实体
 *
 * @author hxpeng
 * <p>
 * Date 2018/10/31 10:09
 */
@AllArgsConstructor
@Builder(toBuilder = true)
@Data
public class QueryProviderAppParamDTO implements Serializable {

    private static final long serialVersionUID = 4589419349248101432L;

    /**
     * 产品名称/APP KEY
     */
    private String keywords;

    /**
     * 媒介
     */
    private String mjCode;

    /**
     * 商务
     */
    private String saleCode;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 是否预付，1：Y， 0：N
     */
    private Integer advanceFlag;

    /**
     * 分页
     */
    private Integer pageNum;
    private Integer pageSize;


    public QueryProviderAppParamDTO() {
        this.pageNum = 1;
        this.pageSize = 20;
    }
}
