package com.bxm.app.model.ro;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

import com.fasterxml.jackson.annotation.JsonFormat;

@Data
public class AppEntranceAdRo implements Serializable {

    private static final long serialVersionUID = 688899615763451690L;

    /**
     * 主键id
     */
    @ApiModelProperty(value = "id")
    private Long id;

    /**
     * appId
     */
    @ApiModelProperty(value = "appId")
    private Integer appId;
    /**
     * appKey
     */
    @ApiModelProperty(value = "appKey")
    private String appKey;
    /**
     * app名称
     */
    @ApiModelProperty(value = "app名称")
    private String appName;

    /**
     * app入口名称(开发者配置)
     */
    @ApiModelProperty(value = "app入口名称(开发者配置)")
    private String appEntranceName;

    /**
     * app入口id(开发者配置)
     */
    @ApiModelProperty(value = "app入口id(开发者配置)")
    private String appEntranceId;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 别名
     */
    @ApiModelProperty(value = "别名")
    private String alias;

    /**
     * 广告位id标识
     */
    @ApiModelProperty(value = "广告位id标识")
    private String positionId;

    /**
     * 媒体类型
     */
    @ApiModelProperty(value = " 媒体类型")
    private String mediaType;

    /**
     * 媒体分类
     */
    @ApiModelProperty(value = "媒体分类")
    private String mediaClass;

    @ApiModelProperty(value = "媒体分类ID")
    private String mediaClassId;

    /**
     * 媒体子分类
     */
    @ApiModelProperty(value = "媒体子分类")
    private String mediaChildClass;

    @ApiModelProperty(value = "媒体子分类ID")
    private String mediaChildClassId;

    /**
     * 对接方式：0获取链接,1JS对接,2API对接，默认0
     */
    @ApiModelProperty(value = "对接方式：0获取链接,1JS对接,2API对接，默认0")
    private Integer dockingMethod;

    /**
     * 素材图片尺寸
     */
    @ApiModelProperty(value = "素材图片尺寸")
    private String imageSize;

    /**
     * 广告位状态：0审核中,1已通过,2已拒绝，默认0
     */
    @ApiModelProperty(value = "广告位状态：0审核中,1已通过,2已拒绝，默认0")
    private Integer state;

    /**
     * 审核不通过原因
     */
    @ApiModelProperty(value = "审核不通过原因")
    private String refuseReason;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @ApiModelProperty(value = "创建时间")
    private Date created;

    /**
     * 媒体创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @ApiModelProperty(value = "媒体创建时间")
    private Date providerAppCreateTime;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date modified;

    @ApiModelProperty(value = "广告位类型")
    private String positionType;

    /**
     * 媒介
     */
    @ApiModelProperty(value = "媒介")
    private String medium;

    /**
     * 上线时间
     */
    @ApiModelProperty(value = "上线时间")
    private String onlineTime;

}
