package com.bxm.app.model.ro;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.bxm.app.model.vo.CustomJsonDateDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

public class ProviderApp implements Serializable {

    /** **/
    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    private Long              id;

    /**
     * 开发者id
     */
    private Long              providerId;

    /**
     * app名称
     */
    private String            appName;

    /**
     * app_key
     */
    private String            appKey;

    /**
     * app类型，h5、app、weixin、weibo等
     */
    private String            appType;

    /**
     * app分配的secret
     */
    private String            appSecret;

    /**
     * app用户余额查询接口
     */
    private String            appBalanceApi;

    /**
     * app用户余额增加接口
     */
    private String            addAppBalanceApi;

    /**
     * app用户余额扣除接口
     */
    private String            deductAppBalanceApi;

    /**
     * app用户余额扣除结果确认接口
     */
    private String            deductAppBalanceConfirmApi;

    /**
     * app用户积分查询接口
     */
    private String            appPointApi;

    /**
     * app用户积分扣除接口
     */
    private String            deductAppPointApi;

    /**
     * app用户积分扣除结果确认接口
     */
    private String            deductAppPointConfirmApi;

    /**
     * 每日扣除预存款限额
     */
    private BigDecimal        budgetPerDay;

    /**
     * 每日扣除预存款剩余限额
     */
    private BigDecimal        budgetPerDayBalance;

    /**
     * 每月扣除预存款限额
     */
    private BigDecimal        budgetPerMonth;

    /**
     * 每月扣除预存款剩余限额
     */
    private BigDecimal        budgetPerMonthBalance;

    /**
     * 开发者自定义商城名称
     */
    private String            mallName;

    /**
     * 积分兑换汇率
     */
    private Double            exchangeRate;

    /**
     * app样式
     */
    private Integer           appStyleId;

    /**
     * app接收推送的接口地址---推送使用
     */
    private String            appPushApi;

    /**
     * 该app币的名称
     */
    private String            coinName;

    /**
     * 是否冻结app,1表示冻结，0表示未冻结
     */
    private Short             isFrozen;

    /**
     * 修改人
     */
    private Long              modifier;

    /**
     * 是否逻辑删除，1表示删除，0表示未删除
     */
    private Short             isDeleted;

    /**
     * 创建时间
     */
    private Date              gmtCreate;

    /**
     * 修改时间
     */
    private Date              gmtModify;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 开发者id
     * 
     * @return provider_id 开发者id
     */
    public Long getProviderId() {
        return providerId;
    }

    /**
     * 开发者id
     * 
     * @param providerId 开发者id
     */
    public void setProviderId(Long providerId) {
        this.providerId = providerId;
    }

    /**
     * app名称
     * 
     * @return app_name app名称
     */
    public String getAppName() {
        return appName;
    }

    /**
     * app名称
     * 
     * @param appName app名称
     */
    public void setAppName(String appName) {
        this.appName = appName == null ? null : appName.trim();
    }

    /**
     * app_key
     * 
     * @return app_key app_key
     */
    public String getAppKey() {
        return appKey;
    }

    /**
     * app_key
     * 
     * @param appKey app_key
     */
    public void setAppKey(String appKey) {
        this.appKey = appKey == null ? null : appKey.trim();
    }

    /**
     * app类型，h5、app、weixin、weibo等
     * 
     * @return app_type app类型，h5、app、weixin、weibo等
     */
    public String getAppType() {
        return appType;
    }

    /**
     * app类型，h5、app、weixin、weibo等
     * 
     * @param appType app类型，h5、app、weixin、weibo等
     */
    public void setAppType(String appType) {
        this.appType = appType == null ? null : appType.trim();
    }

    /**
     * app分配的secret
     * 
     * @return app_secret app分配的secret
     */
    public String getAppSecret() {
        return appSecret;
    }

    /**
     * app分配的secret
     * 
     * @param appSecret app分配的secret
     */
    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret == null ? null : appSecret.trim();
    }

    /**
     * app用户余额查询接口
     * 
     * @return app_balance_api app用户余额查询接口
     */
    public String getAppBalanceApi() {
        return appBalanceApi;
    }

    /**
     * app用户余额查询接口
     * 
     * @param appBalanceApi app用户余额查询接口
     */
    public void setAppBalanceApi(String appBalanceApi) {
        this.appBalanceApi = appBalanceApi == null ? null : appBalanceApi.trim();
    }

    /**
     * app用户余额扣除接口
     * 
     * @return deduct_app_balance_api app用户余额扣除接口
     */
    public String getDeductAppBalanceApi() {
        return deductAppBalanceApi;
    }

    /**
     * app用户余额扣除接口
     * 
     * @param deductAppBalanceApi app用户余额扣除接口
     */
    public void setDeductAppBalanceApi(String deductAppBalanceApi) {
        this.deductAppBalanceApi = deductAppBalanceApi == null ? null : deductAppBalanceApi.trim();
    }

    /**
     * app用户余额扣除结果确认接口
     * 
     * @return deduct_app_balance_confirm_api app用户余额扣除结果确认接口
     */
    public String getDeductAppBalanceConfirmApi() {
        return deductAppBalanceConfirmApi;
    }

    /**
     * app用户余额扣除结果确认接口
     * 
     * @param deductAppBalanceConfirmApi app用户余额扣除结果确认接口
     */
    public void setDeductAppBalanceConfirmApi(String deductAppBalanceConfirmApi) {
        this.deductAppBalanceConfirmApi = deductAppBalanceConfirmApi == null ? null : deductAppBalanceConfirmApi.trim();
    }

    /**
     * app用户积分查询接口
     * 
     * @return app_point_api app用户积分查询接口
     */
    public String getAppPointApi() {
        return appPointApi;
    }

    /**
     * app用户积分查询接口
     * 
     * @param appPointApi app用户积分查询接口
     */
    public void setAppPointApi(String appPointApi) {
        this.appPointApi = appPointApi == null ? null : appPointApi.trim();
    }

    /**
     * app用户积分扣除接口
     * 
     * @return deduct_app_point_api app用户积分扣除接口
     */
    public String getDeductAppPointApi() {
        return deductAppPointApi;
    }

    /**
     * app用户积分扣除接口
     * 
     * @param deductAppPointApi app用户积分扣除接口
     */
    public void setDeductAppPointApi(String deductAppPointApi) {
        this.deductAppPointApi = deductAppPointApi == null ? null : deductAppPointApi.trim();
    }

    /**
     * app用户积分扣除结果确认接口
     * 
     * @return deduct_app_point_confirm_api app用户积分扣除结果确认接口
     */
    public String getDeductAppPointConfirmApi() {
        return deductAppPointConfirmApi;
    }

    /**
     * app用户积分扣除结果确认接口
     * 
     * @param deductAppPointConfirmApi app用户积分扣除结果确认接口
     */
    public void setDeductAppPointConfirmApi(String deductAppPointConfirmApi) {
        this.deductAppPointConfirmApi = deductAppPointConfirmApi == null ? null : deductAppPointConfirmApi.trim();
    }

    /**
     * 每日扣除预存款限额
     * 
     * @return budget_per_day 每日扣除预存款限额
     */
    public BigDecimal getBudgetPerDay() {
        return budgetPerDay;
    }

    /**
     * 每日扣除预存款限额
     * 
     * @param budgetPerDay 每日扣除预存款限额
     */
    public void setBudgetPerDay(BigDecimal budgetPerDay) {
        this.budgetPerDay = budgetPerDay;
    }

    /**
     * 每日扣除预存款剩余限额
     * 
     * @return budget_per_day_balance 每日扣除预存款剩余限额
     */
    public BigDecimal getBudgetPerDayBalance() {
        return budgetPerDayBalance;
    }

    /**
     * 每日扣除预存款剩余限额
     * 
     * @param budgetPerDayBalance 每日扣除预存款剩余限额
     */
    public void setBudgetPerDayBalance(BigDecimal budgetPerDayBalance) {
        this.budgetPerDayBalance = budgetPerDayBalance;
    }

    /**
     * 每月扣除预存款限额
     * 
     * @return budget_per_month 每月扣除预存款限额
     */
    public BigDecimal getBudgetPerMonth() {
        return budgetPerMonth;
    }

    /**
     * 每月扣除预存款限额
     * 
     * @param budgetPerMonth 每月扣除预存款限额
     */
    public void setBudgetPerMonth(BigDecimal budgetPerMonth) {
        this.budgetPerMonth = budgetPerMonth;
    }

    /**
     * 每月扣除预存款剩余限额
     * 
     * @return budget_per_month_balance 每月扣除预存款剩余限额
     */
    public BigDecimal getBudgetPerMonthBalance() {
        return budgetPerMonthBalance;
    }

    /**
     * 每月扣除预存款剩余限额
     * 
     * @param budgetPerMonthBalance 每月扣除预存款剩余限额
     */
    public void setBudgetPerMonthBalance(BigDecimal budgetPerMonthBalance) {
        this.budgetPerMonthBalance = budgetPerMonthBalance;
    }

    /**
     * 开发者自定义商城名称
     * 
     * @return mall_name 开发者自定义商城名称
     */
    public String getMallName() {
        return mallName;
    }

    /**
     * 开发者自定义商城名称
     * 
     * @param mallName 开发者自定义商城名称
     */
    public void setMallName(String mallName) {
        this.mallName = mallName == null ? null : mallName.trim();
    }

    /**
     * 积分兑换汇率
     * 
     * @return exchange_rate 积分兑换汇率
     */
    public Double getExchangeRate() {
        return exchangeRate;
    }

    /**
     * 积分兑换汇率
     * 
     * @param exchangeRate 积分兑换汇率
     */
    public void setExchangeRate(Double exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    /**
     * app样式
     * 
     * @return app_style_id app样式
     */
    public Integer getAppStyleId() {
        return appStyleId;
    }

    /**
     * app样式
     * 
     * @param appStyleId app样式
     */
    public void setAppStyleId(Integer appStyleId) {
        this.appStyleId = appStyleId;
    }

    /**
     * app接收推送的接口地址---推送使用
     * 
     * @return app_push_api app接收推送的接口地址---推送使用
     */
    public String getAppPushApi() {
        return appPushApi;
    }

    /**
     * app接收推送的接口地址---推送使用
     * 
     * @param appPushApi app接收推送的接口地址---推送使用
     */
    public void setAppPushApi(String appPushApi) {
        this.appPushApi = appPushApi == null ? null : appPushApi.trim();
    }

    /**
     * 该app币的名称
     * 
     * @return coin_name 该app币的名称
     */
    public String getCoinName() {
        return coinName;
    }

    /**
     * 该app币的名称
     * 
     * @param coinName 该app币的名称
     */
    public void setCoinName(String coinName) {
        this.coinName = coinName == null ? null : coinName.trim();
    }

    /**
     * 是否冻结app,1表示冻结，0表示未冻结
     * 
     * @return is_frozen 是否冻结app,1表示冻结，0表示未冻结
     */
    public Short getIsFrozen() {
        return isFrozen;
    }

    /**
     * 是否冻结app,1表示冻结，0表示未冻结
     * 
     * @param isFrozen 是否冻结app,1表示冻结，0表示未冻结
     */
    public void setIsFrozen(Short isFrozen) {
        this.isFrozen = isFrozen;
    }

    /**
     * 修改人
     * 
     * @return modifier 修改人
     */
    public Long getModifier() {
        return modifier;
    }

    /**
     * 修改人
     * 
     * @param modifier 修改人
     */
    public void setModifier(Long modifier) {
        this.modifier = modifier;
    }

    /**
     * 是否逻辑删除，1表示删除，0表示未删除
     * 
     * @return is_deleted 是否逻辑删除，1表示删除，0表示未删除
     */
    public Short getIsDeleted() {
        return isDeleted;
    }

    /**
     * 是否逻辑删除，1表示删除，0表示未删除
     * 
     * @param isDeleted 是否逻辑删除，1表示删除，0表示未删除
     */
    public void setIsDeleted(Short isDeleted) {
        this.isDeleted = isDeleted;
    }

    /**
     * 创建时间
     * 
     * @return gmt_create 创建时间
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * 创建时间
     * 
     * @param gmtCreate 创建时间
     */
    @JsonDeserialize(using = CustomJsonDateDeserializer.class)
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * 修改时间
     * 
     * @return gmt_modify 修改时间
     */
    public Date getGmtModify() {
        return gmtModify;
    }

    /**
     * 修改时间
     * 
     * @param gmtModify 修改时间
     */
    @JsonDeserialize(using = CustomJsonDateDeserializer.class)
    public void setGmtModify(Date gmtModify) {
        this.gmtModify = gmtModify;
    }

    /**
     * @return the addAppBalanceApi
     */
    public String getAddAppBalanceApi() {
        return addAppBalanceApi;
    }

    /**
     * @param addAppBalanceApi the addAppBalanceApi to set
     */
    public void setAddAppBalanceApi(String addAppBalanceApi) {
        this.addAppBalanceApi = addAppBalanceApi;
    }
}
