package com.bxm.app.model.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/8/30 17:51
 * 修 改 人：
 * 日 期：
 * 描 述： 预付媒体流水VO
 * 版 本 号： v1
 */
@Data
public class AdvanceAppFlowRecordTotalVo implements Serializable {
    private static final long serialVersionUID = -7870851633869844593L;

    /**
     * 媒体名称，媒体key，媒体创建时间
     */
    private String appName;
    private String alias;
    private String appKey;
    private Date appCreateTime;

    /**
     * 当前余额， 历史总消耗， 历史总充值
     */
    private BigDecimal currentlyBalance;
    private BigDecimal totalConsume;
    private BigDecimal totalRecharge;


    public AdvanceAppFlowRecordTotalVo() {
        this.currentlyBalance = BigDecimal.ZERO;
        this.totalConsume = BigDecimal.ZERO;
        this.totalRecharge = BigDecimal.ZERO;
    }

    public AdvanceAppFlowRecordTotalVo(String appName, String appKey, Date appCreateTime) {
        this.appName = appName;
        this.appKey = appKey;
        this.appCreateTime = appCreateTime;
        this.currentlyBalance = BigDecimal.ZERO;
        this.totalConsume = BigDecimal.ZERO;
        this.totalRecharge = BigDecimal.ZERO;
    }

}
