package com.bxm.app.model.vo;

import lombok.Data;

import java.io.Serializable;

/**
 * Description 运营后台 查询 开发者媒体 请求返回结果
 * 备注：参数定义， 均根据原来接口的返回值一样，这样前端不需要改
 *
 * @author hxpeng
 * <p>
 * Date 2018/10/31 10:14
 */
@Data
public class ProviderAppForAdsmanagerVO implements Serializable {

    private static final long serialVersionUID = -3196527523678187843L;

    /**
     * appKey， 媒体名称
     */
    private String appkey;
    private String appname;

    /**
     * 商务名称，商务code
     */
    private String bdText;
    private String bdcode;

    /**
     * 子链接个数
     */
    private Integer businessCount;

    /**
     * 媒介名称， 媒介code
     */
    private String mjText;
    private String mjcode;

    /**
     * 编号，自增
     */
    private Integer number;

    /**
     * 是否预付
     */
    private Integer advanceType;
    private Boolean prepay;

    /**
     * 备注
     */
    private String remark;

    /**
     * 客户类型，0：直客，1：代理，2：子账号
     */
    private Integer accountType;

}
