/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dspams.common.helper.exception;

import com.bxm.dspams.common.helper.exception.DspamsException;
import com.mysql.jdbc.exceptions.jdbc4.MySQLIntegrityConstraintViolationException;
import feign.FeignException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.support.MissingServletRequestPartException;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private static final Pattern PATTERN_FEIGN = Pattern.compile("^.*; content:[\\r|\\n]*(.*)$");
    @Autowired
    private Environment environment;

    @ExceptionHandler(value={BindException.class, HttpMessageNotReadableException.class, MissingServletRequestPartException.class, TypeMismatchException.class, ConstraintViolationException.class, IllegalStateException.class, IllegalArgumentException.class, UnsupportedOperationException.class, HttpMediaTypeNotAcceptableException.class, HttpMediaTypeNotSupportedException.class})
    @ResponseBody
    public Object handleBadRequestException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        log.error("\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
        return ResponseEntity.badRequest().body((Object)e.getMessage());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public ResponseEntity<String> httpRequestMethodNotSupported(HttpRequestMethodNotSupportedException e) {
        return ResponseEntity.badRequest().body((Object)"\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u652f\u6301\uff0c\u8bf7\u786e\u8ba4\uff01");
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    public ResponseEntity<String> handleRequestParameterException(MissingServletRequestParameterException e) {
        return ResponseEntity.badRequest().body((Object)(e.getParameterName() + "\uff1a\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01"));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public ResponseEntity<String> handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        return ResponseEntity.badRequest().body((Object)((FieldError)e.getBindingResult().getFieldErrors().get(0)).getDefaultMessage());
    }

    @ExceptionHandler(value={ServletRequestBindingException.class})
    @ResponseBody
    public ResponseEntity<String> handleRequestBindingException(ServletRequestBindingException e) {
        return ResponseEntity.badRequest().body((Object)"\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01");
    }

    @ExceptionHandler(value={MySQLIntegrityConstraintViolationException.class, DuplicateKeyException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public Object handleDuplicateKeyException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5b58\u5728\u91cd\u590d\u7684\u552f\u4e00\u503c");
    }

    @ExceptionHandler(value={DataAccessException.class})
    @ResponseBody
    public ResponseEntity<String> dataAccess(DataAccessException e) {
        return ResponseEntity.badRequest().body((Object)"\u6570\u636e\u64cd\u4f5c\u5f02\u5e38");
    }

    @ExceptionHandler(value={DspamsException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public Object handleMcException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        return ResponseEntity.badRequest().body((Object)e.getMessage());
    }

    @ExceptionHandler(value={FeignException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public Object handleFeignException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        String message = null;
        Matcher matcher = PATTERN_FEIGN.matcher(e.getMessage());
        message = matcher.find() ? matcher.group(1) : e.getMessage();
        return ResponseEntity.badRequest().body((Object)message);
    }
}

