/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dspams.common.integration.datapark;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.web.FacadeAssemblyDataService;
import com.bxm.datapark.web.FacadeSspActivityDataServive;
import com.bxm.datapark.web.FacadeSspCreativeDataServive;
import com.bxm.datapark.web.FacadeSspPositionDataServive;
import com.bxm.datapark.web.model.AssemblyData;
import com.bxm.datapark.web.model.AssemblyDataDTO;
import com.bxm.datapark.web.model.SspActivity;
import com.bxm.datapark.web.model.SspActivityData;
import com.bxm.datapark.web.model.SspActivityDataDTO;
import com.bxm.datapark.web.model.SspCreativeDaily;
import com.bxm.datapark.web.model.SspPositionFinanceDaily;
import com.bxm.warcar.utils.response.ResultModel;
import com.google.common.collect.Lists;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Configuration;

@EnableFeignClients(value={"com.bxm.datapark.web"})
@Configuration
public class DataparkWebIntegration {
    private static final Logger log = LoggerFactory.getLogger(DataparkWebIntegration.class);
    @Autowired
    private FacadeSspPositionDataServive facadeSspPositionDataServive;
    @Autowired
    private FacadeAssemblyDataService facadeAssemblyDataService;
    @Autowired
    private FacadeSspCreativeDataServive facadeSspCreativeDataServive;
    @Autowired
    private FacadeSspActivityDataServive facadeSspActivityDataServive;

    public List<SspPositionFinanceDaily> getPositionDspData(SspPositionFinanceDaily search) {
        ResultModel positionDspData = this.facadeSspPositionDataServive.getPositionDspData(search);
        if (positionDspData.isSuccessed()) {
            return (List)positionDspData.getReturnValue();
        }
        return Lists.newArrayList();
    }

    public Page<AssemblyData> getAssemblyData(AssemblyDataDTO search) {
        try {
            ResultModel resultModel = this.facadeAssemblyDataService.getAssemblyData(search);
            if (resultModel.isSuccessed()) {
                return (Page)resultModel.getReturnValue();
            }
            log.error("\u8c03\u7528datapark getAssemblyData \u670d\u52a1\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528datapark getAssemblyData \u670d\u52a1\u5f02\u5e38\uff01", (Throwable)e);
        }
        return new Page();
    }

    public List<SspActivity> getActivity(SspActivity search) {
        try {
            ResultModel resultModel = this.facadeSspActivityDataServive.getActivity(search);
            if (resultModel.isSuccessed()) {
                return (List)resultModel.getReturnValue();
            }
            log.error("\u8c03\u7528datapark getActivity \u670d\u52a1\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528datapark getActivity \u670d\u52a1\u5f02\u5e38\uff01", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    public List<SspActivityData> getActivityData(SspActivityDataDTO search) {
        try {
            ResultModel resultModel = this.facadeSspActivityDataServive.getActivityData(search);
            if (resultModel.isSuccessed()) {
                return (List)resultModel.getReturnValue();
            }
            log.error("\u8c03\u7528datapark getActivityData \u670d\u52a1\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528datapark getActivityData \u670d\u52a1\u5f02\u5e38\uff01", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    public List<SspCreativeDaily> getCreativeData(SspCreativeDaily search) {
        try {
            ResultModel resultModel = this.facadeSspCreativeDataServive.getCreativeData(search);
            if (resultModel.isSuccessed()) {
                return (List)resultModel.getReturnValue();
            }
            log.error("\u8c03\u7528datapark getCreativeData \u670d\u52a1\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528datapark getCreativeData \u670d\u52a1\u5f02\u5e38\uff01", (Throwable)e);
        }
        return Lists.newArrayList();
    }
}

