/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dspams.common.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static Date getEndOfDay(Date date) {
        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.setTime(date);
        calendarEnd.set(11, 23);
        calendarEnd.set(12, 59);
        calendarEnd.set(13, 59);
        calendarEnd.set(14, 0);
        return calendarEnd.getTime();
    }

    public static Date getStartOfDay(Date date) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime startOfDay = localDateTime.with(LocalTime.MIN);
        return Date.from(startOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static boolean before(Date when) {
        return DateUtil.after(new Date(), when);
    }

    public static boolean after(Date when) {
        return DateUtil.after(when, new Date());
    }

    public static boolean after(Date source, Date target) {
        if (null == source || null == target) {
            return false;
        }
        Calendar sourceCalendar = Calendar.getInstance();
        sourceCalendar.setTime(source);
        return source.after(target);
    }
}

