package com.bxm.messager.common.core.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bxm.messager.common.model.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author pf.w
 * @since 2021-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_message_info")
public class MessageInfoEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 标题
     */
    private String title;

    /**
     * 1:正文  0：模板
     */
    private Integer type;

    /**
     * 推送类型 0：活动  1：处罚公示 2：政策通知  3：客情维护  4：节日通知 5:系统消息
     */
    private Integer pushTopicType;

    /**
     * 推送对象类型 0：媒体   1：广告主
     */
    private Integer pushGoalType;

    /**
     * 对象描述 媒体 | 广告主
     */
    private String pushGoalDesc;

    /**
     * 推送对象收件人类型   0：全员  1：指定用户
     */
    private Integer pushGoalUserType;

    /**
     * 推送收件人指定用户  ","逗号隔开
     */
    private String pushGoalUserContent;

    /**
     * 推送正文 富文本内容
     */
    private String pushContent;

    /**
     * 推送消息状态  0：待发送   1：已发送   2：撤回
     */
    private Integer pushStatus;

    /**
     * 记录状态  1：已删除   0：可用
     */
    private Integer deleted;

    /**
     * 推送时间
     */
    private Date pushDataTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 修改人
     */
    private String updateUser;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;

}
