package com.bxm.messager.common.core.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bxm.messager.common.model.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author pf.w
 * @since 2021-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_message_read_info")
public class MessageReadInfoEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 对象类型  0：媒体  1：广告主
     */
    private Integer goalType;

    /**
     * 消息id
     */
    private Long messageId;

    /**
     * 目标用户id
     */
    private Long goalUserId;

    /**
     * 是否已读  0：未读  1：已读
     */
    private Integer readFlag;

    /**
     * 已读时间
     */
    private Date readTime;

    /**
     * 软删除   1：已删除   0：未删除
     */
    private Integer deleted;

    /**
     * 删除时间
     */
    private Date deletedTime;
}
