package com.bxm.messager.common.core.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.messager.common.core.entity.MessageInfoEntity;
import com.bxm.messager.common.model.bo.MessageInfoFacadeParamBO;
import com.bxm.messager.common.model.dto.MessageListExportDTO;
import com.bxm.messager.common.model.dto.MessageListInfoDTO;
import com.bxm.messager.common.model.dto.MessageTemplateDTO;
import com.bxm.messager.common.model.vo.MessageListInfoVO;
import com.bxm.messager.common.model.vo.MessageTemplateListInfoVO;
import com.bxm.messager.facade.vo.MessageInfoListVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author pf.w
 * @since 2021-08-17
 */
@Mapper
public interface MessageInfoMapper extends BaseMapper<MessageInfoEntity> {

    /**
     * 多条件组合查询获取消息列表
     *
     * @param page 分页参数
     * @param query 多条件组合查询参数
     * @return 分页集合
     */
    IPage<MessageListInfoVO> getMessageInfoList(Page<MessageListInfoVO> page, @Param("query") MessageListInfoDTO query);

    /**
     * 获取模板列表
     * @param page 分页参数
     * @param param 查询条件
     * @return 模板数据集合
     */
    IPage<MessageTemplateListInfoVO> getMessageTemplateList(Page<MessageTemplateListInfoVO> page,@Param("query") MessageTemplateDTO param);

    /**
     *
     * facade 查询各个主体消息列表
     *
     * @param page  分页参数
     * @param query 查询参数
     * @return 分页集合
     */
    IPage<MessageInfoListVO> getMessageListForFacade(Page<MessageInfoListVO> page, @Param("query")MessageInfoFacadeParamBO query);

    /**
     * 导出报表数据查询
     * @param query
     * @return
     */
    List<MessageListInfoVO> getMessageInfoListExport(@Param("query") MessageListExportDTO query);

    /**
     * 更改状态
     * @return
     */
    void updatePushStatus();

}
