/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.messager.common.helper.autoconfigure;

import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

import java.nio.charset.StandardCharsets;

/**
 * RestTemplate初始化<br/>
 *
 * @author kerry.jiang
 * @date 2020/2/11 10:43
 */
@Configuration
public class RestTemplateConfiguration {

	/**
	 * 调用接口使用的<br/>
	 * 超时时间比较长<br/>
	 *
	 * @return RestTemplate实例
	 */
	@Bean
	public RestTemplate restTemplate() {
		Registry<ConnectionSocketFactory> registry = RegistryBuilder.<ConnectionSocketFactory> create()
				.register("http", PlainConnectionSocketFactory.getSocketFactory())
				.register("https", SSLConnectionSocketFactory.getSocketFactory())
				.build();
		PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
		connectionManager.setMaxTotal(30);//整个连接池最大连接数
		connectionManager.setDefaultMaxPerRoute(30);//每路由最大连接数，默认值是2


		RequestConfig requestConfig = RequestConfig.custom()
				.setSocketTimeout(3000)//读取服务端数据超时
				.setConnectTimeout(3000)//建立连接超时
				.setConnectionRequestTimeout(1000)//连接池中获取请求超时
				.build();

		HttpClient httpClient = HttpClientBuilder.create()
				.setDefaultRequestConfig(requestConfig)
				.setConnectionManager(connectionManager)
				.build();
		RestTemplate restTemplate = new RestTemplate(new HttpComponentsClientHttpRequestFactory(httpClient));
		//中文乱码问题
		restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
		return restTemplate;
	}
	
}
