package com.bxm.messager.common.integration.adsmedia;

import com.bxm.adsmedia.facade.income.PositionIncomeFacadeService;
import com.bxm.adsmedia.facade.income.PositionIncomeVO;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.stereotype.Service;
import com.bxm.warcar.utils.response.ResultModel;

import java.util.List;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/11/30 17:03
 */
@Service
@EnableFeignClients("com.bxm.adsmedia.facade")
public class PositionIncomeIntegration {

    @Autowired
    private PositionIncomeFacadeService positionIncomeFacadeService;

    public List<PositionIncomeVO> getPositionIncome(List<String> positions, String datetime) {
        PositionIncomeVO positionIncomeVO = new PositionIncomeVO();
        positionIncomeVO.setQueryPositionIds(positions);
        positionIncomeVO.setDate(datetime);
        ResultModel<List<PositionIncomeVO>> positionIncome = positionIncomeFacadeService.getPositionIncome(positionIncomeVO);
        if (positionIncome.isSuccessed()) {
            return positionIncome.getReturnValue();
        }
        return Lists.newArrayList();
    }

}
