package com.bxm.messager.common.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.messager.common.core.entity.MessageInfoEntity;
import com.bxm.messager.common.core.entity.MessagePushTopicInfoEntity;
import com.bxm.messager.common.core.mapper.MessageInfoMapper;
import com.bxm.messager.common.core.service.MessageInfoService;
import com.bxm.messager.common.core.service.MessagePushTopicInfoService;
import com.bxm.messager.common.helper.util.UserRoleUtil;
import com.bxm.messager.common.model.dto.MessageDetailInfoDTO;
import com.bxm.messager.common.model.dto.MessageListExportDTO;
import com.bxm.messager.common.model.dto.MessageListInfoDTO;
import com.bxm.messager.common.model.vo.MessageDetailInfoVO;
import com.bxm.messager.common.model.vo.MessageListInfoVO;
import com.bxm.messager.common.model.vo.MessageTopicListInfoVO;
import com.bxm.messager.common.service.MessageService;
import com.bxm.messager.common.service.coverter.MessageCovert;
import com.bxm.messager.common.util.DateUtil;
import com.bxm.messager.common.util.ExcelUtil;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author pf.w
 * @date 2021/8/18 15:17
 **/
@Service
@Slf4j
@AllArgsConstructor
public class MessageServiceImpl implements MessageService {

    private final MessagePushTopicInfoService messagePushTopicInfoService;

    private final MessageInfoService messageInfoService;

    private final MessageInfoMapper messageInfoMapper;

    @Override
    public IPage<MessageListInfoVO> getMessageList(MessageListInfoDTO param) {
        Page<MessageListInfoVO> page = new Page<>(param.getPageNum(),param.getPageSize());

        if(!Objects.isNull(param.getEndTime())){
            param.setStartTime(DateUtil.getStartOfDay(param.getStartTime()));
            param.setEndTime(DateUtil.getEndOfDay(param.getEndTime()));
        }
        return messageInfoMapper.getMessageInfoList(page,param);
    }

    @Override
    public Boolean addMessage(MessageDetailInfoDTO param) {

        //获取系统登录用户信息
        String username = UserRoleUtil.getUser().getUsername();

        param.setCreateUser(Objects.isNull(username) ? "默认" : username);
        return messageInfoService.save(param);
    }

    @Override
    public Boolean editMessage(MessageDetailInfoDTO param) {
        if(Objects.isNull(param.getId())){
            return Boolean.FALSE;
        }

        //获取系统登录用户信息
        String username = UserRoleUtil.getUser().getUsername();

        param.setUpdateUser(Objects.isNull(username) ? "默认" : username);

        return messageInfoService.updateById(param);
    }

    @Override
    public MessageDetailInfoVO getMessageInfo(Long messageId) {
        return MessageCovert.INSTANCE.toMessageDetailInoVo(messageInfoService.getById(messageId));
    }

    @Override
    public Boolean messageOperate(Long messageId, Integer operateType) {

        MessageInfoEntity entity = messageInfoService.getById(messageId);

        if(Objects.isNull(entity)){
            return false;
        }

        boolean resultFlag;

        switch (operateType){
            case 0:
                //删除
                entity.setDeleted(1);
                resultFlag = messageInfoService.updateById(entity);
                break;
            case 1:
                //撤回
                entity.setPushStatus(2);
                resultFlag = messageInfoService.updateById(entity);
                break;
               default:
                   resultFlag = false;
        }
        return resultFlag;
    }

    @Override
    public void messageListExport(MessageListExportDTO param, HttpServletResponse response) {
        List<MessageListInfoVO> list = messageInfoMapper.getMessageInfoListExport(param);
        if(CollectionUtils.isEmpty(list)){
            return;
        }
        if(!Objects.isNull(param.getEndTime())){
            param.setStartTime(DateUtil.getStartOfDay(param.getStartTime()));
            param.setEndTime(DateUtil.getEndOfDay(param.getEndTime()));
        }

        list.forEach(messageListInfoVO -> {
            messageListInfoVO.setPushStatusDesc(messageListInfoVO.getPushStatus()==0 ? "待发送" : messageListInfoVO.getPushStatus()==1 ? "已发送" : "撤回");
        });
        ExcelUtil.exportExcel(list, null, "消息报表", MessageListInfoVO.class, "消息报表.xls",
                response);
    }

    @Override
    public List<MessageTopicListInfoVO> getMessageTopicInfo() {
        List<MessagePushTopicInfoEntity> topicListDb = messagePushTopicInfoService.list();

        if(CollectionUtils.isEmpty(topicListDb)){
            return Lists.newArrayList();
        }
        return topicListDb.stream().map(MessageCovert.INSTANCE::toTopicListInfoVo).collect(Collectors.toList());
    }

    @Override
    public void updateMessagePushStatusTimes() {
        messageInfoMapper.updatePushStatus();
    }
}
