package com.bxm.messager.common.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.messager.common.core.mapper.MessageInfoMapper;
import com.bxm.messager.common.model.dto.MessageTemplateDTO;
import com.bxm.messager.common.model.vo.MessageTemplateListInfoVO;
import com.bxm.messager.common.service.MessageTemplateService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author pf.w
 * @date 2021/8/23 9:37
 **/
@Service
@Slf4j
@AllArgsConstructor
public class MessageTemplateServiceImpl implements MessageTemplateService {

    private final MessageInfoMapper messageInfoMapper;

    @Override
    public IPage<MessageTemplateListInfoVO> getMessageTemplateList(MessageTemplateDTO param) {
        if(log.isDebugEnabled()){
            log.debug("messageTemplateList param : {}",param);
        }
        //分页参数
        Page<MessageTemplateListInfoVO> page = new Page<>(param.getPageNum(),param.getPageSize());

        return messageInfoMapper.getMessageTemplateList(page,param);
    }
}
