/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.messager.common.integration.acl;

import com.bxm.acl.facade.AclUserService;
import com.bxm.acl.facade.model.ResultModel;
import com.bxm.acl.facade.model.UserRo;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.stereotype.Service;

@Service
@EnableFeignClients(value={"com.bxm.acl.facade"})
public class AclUserIntegration {
    private static final Logger log = LoggerFactory.getLogger(AclUserIntegration.class);
    @Resource
    private AclUserService aclUserService;

    public Map<String, String> queryUserByRoleCode(String roleCode, Boolean onlyShowEnable) {
        try {
            ResultModel response = this.aclUserService.queryUserByRoleCode(roleCode, onlyShowEnable);
            if (response != null && response.isSuccessed() && response.getReturnValue() != null) {
                return (Map)response.getReturnValue();
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u6743\u9650\u7cfb\u7edf\u67e5\u8be2\u89d2\u8272\u5bf9\u5e94\u7528\u6237\u4fe1\u606f\u5f02\u5e38:", (Throwable)e);
        }
        return Collections.emptyMap();
    }

    public UserRo getUserByUsername(String username) {
        try {
            ResultModel response = this.aclUserService.getUserByUsername(username);
            if (response != null && response.isSuccessed() && response.getReturnValue() != null) {
                return (UserRo)response.getReturnValue();
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u6743\u9650\u7cfb\u7edf\u67e5\u8be2username\u5bf9\u5e94\u7528\u6237\u4fe1\u606f\u5f02\u5e38:", (Throwable)e);
        }
        return null;
    }
}

