package com.bxm.messager.controller.base;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.messager.common.model.base.BaseEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 前端控制器基类<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/16 20:05
 */
public abstract class BaseController<T extends BaseEntity> extends WithoutAnnotationBaseController<T> {

    @PostMapping("/post")
    @Override
    public ResponseEntity<T> post(@RequestBody T t) {
        return super.post(t);
    }

    @PutMapping("/put")
    @Override
    public ResponseEntity<T> put(@RequestBody T t) {
        return super.put(t);
    }

    @GetMapping("/get")
    @Override
    public ResponseEntity<T> get(Long id) {
        return super.get(id);
    }

    @GetMapping("/list")
    @Override
    public ResponseEntity<List<T>> list(Page page, T query) {
        return super.list(page, query);
    }

    @GetMapping("/page")
    @Override
    public ResponseEntity<IPage<T>> page(Page<T> page, T query) {
        return super.page(page, query);
    }
}