package com.bxm.messager.controller.message;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.messager.common.model.dto.MessageTemplateDTO;
import com.bxm.messager.common.model.vo.MessageTemplateListInfoVO;
import com.bxm.messager.common.service.MessageTemplateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author pf.w
 * @date 2021/8/17 18:37
 **/
@RestController
@RequestMapping("/message/template")
public class MessageTemplateController {

    @Autowired
    private  MessageTemplateService messageTemplateService;

    @RequestMapping("getMessageTemplateList")
    public ResponseEntity<IPage<MessageTemplateListInfoVO>> getMessageTemplateList(MessageTemplateDTO param){
        return ResponseEntity.ok(messageTemplateService.getMessageTemplateList(param));
    }
}
