package com.bxm.messager.controller.message;

import com.bxm.messager.common.service.MessageService;
import com.bxm.messager.common.service.SyncMessageSevice;
import lombok.AllArgsConstructor;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/times")
@AllArgsConstructor
public class MessageTimeController {


    private final MessageService messageService;

    private final SyncMessageSevice syncMessageSevice;

    /**
     * 接口 定时更改状态
     */
    @GetMapping("/updatePushStatus")
    public ResponseEntity<Boolean> updatePushStatus(){
        messageService.updateMessagePushStatusTimes();
      return ResponseEntity.ok(Boolean.TRUE);
    }

    @GetMapping("/syncAdsMediaMessage")
    public ResponseEntity<Boolean> syncAdsMediaMessage(){
        syncMessageSevice.syncAdsMediaMessage();
        return ResponseEntity.ok(Boolean.TRUE);
    }

    @GetMapping("/syncCatMessage")
    public ResponseEntity<Boolean> syncCatMessage(){
        syncMessageSevice.syncCatMessage();
        return ResponseEntity.ok(Boolean.TRUE);
    }
}
