/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.messager.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.messager.common.core.entity.AdsmediaStationMsgEntity;
import com.bxm.messager.common.core.entity.AdsmediaStationSysMsgStatusEntity;
import com.bxm.messager.common.core.entity.CatStationMsgEntity;
import com.bxm.messager.common.core.entity.CatStationSysMsgStatusEntity;
import com.bxm.messager.common.core.entity.MessageInfoEntity;
import com.bxm.messager.common.core.entity.MessageReadInfoEntity;
import com.bxm.messager.common.core.service.AdsmediaStationMsgService;
import com.bxm.messager.common.core.service.AdsmediaStationSysMsgStatusService;
import com.bxm.messager.common.core.service.CatStationMsgService;
import com.bxm.messager.common.core.service.CatStationSysMsgStatusService;
import com.bxm.messager.common.core.service.MessageInfoService;
import com.bxm.messager.common.core.service.MessageReadInfoService;
import com.bxm.messager.common.service.SyncMessageSevice;
import com.bxm.messager.common.util.DateUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SyncMessageServiceImpl
implements SyncMessageSevice {
    private static final Logger log = LoggerFactory.getLogger(SyncMessageServiceImpl.class);
    private final AdsmediaStationMsgService adsmediaStationMsgService;
    private final AdsmediaStationSysMsgStatusService adsmediaStationSysMsgStatusService;
    private final CatStationMsgService catStationMsgService;
    private final CatStationSysMsgStatusService catStationSysMsgStatusService;
    private final MessageInfoService messageInfoService;
    private final MessageReadInfoService messageReadInfoService;

    @Override
    public Boolean syncAdsMediaMessage() {
        List asmeList = this.adsmediaStationMsgService.list();
        if (!CollectionUtils.isEmpty((Collection)asmeList)) {
            for (AdsmediaStationMsgEntity adsEntity : asmeList) {
                MessageInfoEntity entity = new MessageInfoEntity();
                entity.setTitle(Objects.isNull(adsEntity.getSubject()) ? null : adsEntity.getSubject());
                entity.setType(1);
                entity.setPushTopicType(5);
                entity.setPushGoalType(0);
                entity.setPushGoalDesc("\u5a92\u4f53");
                entity.setPushGoalUserType(adsEntity.getReceiverId() == 0L ? 0 : 1);
                if (adsEntity.getReceiverId() != 0L) {
                    entity.setPushGoalUserContent(adsEntity.getReceiverId().toString());
                }
                entity.setPushContent(Objects.isNull(adsEntity.getContext()) ? null : adsEntity.getContext());
                entity.setDeleted(adsEntity.getDeletedFlag() != false ? 1 : 0);
                entity.setPushStatus(DateUtil.before(adsEntity.getSendDate()) ? 1 : 0);
                entity.setPushDataTime(adsEntity.getSendDate());
                entity.setCreateUser("adsmedia");
                this.messageInfoService.save(entity);
                log.info("=====\u5bfc\u5165\u6d88\u606fid : {}\uff0c\u5b8c\u6210", (Object)entity.getId());
                if (adsEntity.getReceiverId() == 0L) {
                    LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                    lambdaQueryWrapper.eq(AdsmediaStationSysMsgStatusEntity::getMsgId, (Object)adsEntity.getId());
                    List statusList = this.adsmediaStationSysMsgStatusService.list((Wrapper)lambdaQueryWrapper);
                    if (CollectionUtils.isEmpty((Collection)statusList)) continue;
                    for (AdsmediaStationSysMsgStatusEntity adsStatusEntity : statusList) {
                        if (!adsStatusEntity.getReadFlag().booleanValue()) continue;
                        MessageReadInfoEntity readInfoEntity = new MessageReadInfoEntity();
                        readInfoEntity.setGoalType(0);
                        readInfoEntity.setMessageId(entity.getId());
                        readInfoEntity.setGoalUserId(adsStatusEntity.getReceiverId());
                        readInfoEntity.setReadFlag(adsStatusEntity.getReadFlag() != false ? 1 : 0);
                        readInfoEntity.setReadTime(adsStatusEntity.getReadTime());
                        readInfoEntity.setDeleted(adsStatusEntity.getDeletedFlag() != false ? 1 : 0);
                        readInfoEntity.setDeletedTime(Objects.isNull(adsStatusEntity.getDeletedTime()) ? null : adsStatusEntity.getDeletedTime());
                        this.messageReadInfoService.save(readInfoEntity);
                        log.info("----\u5bfc\u5165\u5df2\u8bfb\u6d88\u606fid:{}\uff0c\u5b8c\u6210", (Object)readInfoEntity.getId());
                    }
                    continue;
                }
                MessageReadInfoEntity readInfoEntity = new MessageReadInfoEntity();
                readInfoEntity.setGoalType(0);
                readInfoEntity.setMessageId(entity.getId());
                readInfoEntity.setGoalUserId(adsEntity.getReceiverId());
                readInfoEntity.setReadFlag(adsEntity.getHadReadFlag() != false ? 1 : 0);
                readInfoEntity.setDeleted(adsEntity.getDeletedFlag() != false ? 1 : 0);
                this.messageReadInfoService.save(readInfoEntity);
                log.info("----\u5bfc\u5165\u5df2\u8bfb\u6d88\u606fid:{}\uff0c\u5b8c\u6210", (Object)readInfoEntity.getId());
            }
        }
        return true;
    }

    @Override
    public Boolean syncCatMessage() {
        List catMsgList = this.catStationMsgService.list();
        if (!CollectionUtils.isEmpty((Collection)catMsgList)) {
            for (CatStationMsgEntity catEntity : catMsgList) {
                MessageInfoEntity entity = new MessageInfoEntity();
                entity.setTitle(Objects.isNull(catEntity.getSubject()) ? null : catEntity.getSubject());
                entity.setType(1);
                entity.setPushTopicType(5);
                entity.setPushGoalType(0);
                entity.setPushGoalDesc("\u5a92\u4f53");
                entity.setPushGoalUserType(catEntity.getReceiverId() == 0L ? 0 : 1);
                if (catEntity.getReceiverId() != 0L) {
                    entity.setPushGoalUserContent(catEntity.getReceiverId().toString());
                }
                entity.setPushContent(Objects.isNull(catEntity.getContext()) ? null : catEntity.getContext());
                entity.setDeleted(catEntity.getDeleted());
                entity.setPushStatus(DateUtil.before(catEntity.getSendDate()) ? 1 : 0);
                entity.setPushDataTime(catEntity.getSendDate());
                entity.setCreateUser("mcssp");
                this.messageInfoService.save(entity);
                log.info("=====\u5bfc\u5165\u6d88\u606fid : {}\uff0c\u5b8c\u6210", (Object)entity.getId());
                if (catEntity.getReceiverId() == 0L) {
                    LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                    lambdaQueryWrapper.eq(CatStationSysMsgStatusEntity::getMsgId, (Object)catEntity.getId());
                    List statusList = this.catStationSysMsgStatusService.list((Wrapper)lambdaQueryWrapper);
                    if (CollectionUtils.isEmpty((Collection)statusList)) continue;
                    for (CatStationSysMsgStatusEntity catStatusEntity : statusList) {
                        if (catStatusEntity.getReadFlag() != 1) continue;
                        MessageReadInfoEntity readInfoEntity = new MessageReadInfoEntity();
                        readInfoEntity.setGoalType(0);
                        readInfoEntity.setMessageId(entity.getId());
                        readInfoEntity.setGoalUserId(catStatusEntity.getReceiverId());
                        readInfoEntity.setReadFlag(catStatusEntity.getReadFlag());
                        readInfoEntity.setReadTime(catStatusEntity.getReadTime());
                        readInfoEntity.setDeleted(catStatusEntity.getDeleted());
                        readInfoEntity.setDeletedTime(Objects.isNull(catStatusEntity.getDeletedTime()) ? null : catStatusEntity.getDeletedTime());
                        this.messageReadInfoService.save(readInfoEntity);
                        log.info("----\u5bfc\u5165\u5df2\u8bfb\u6d88\u606fid:{}\uff0c\u5b8c\u6210", (Object)readInfoEntity.getId());
                    }
                    continue;
                }
                MessageReadInfoEntity readInfoEntity = new MessageReadInfoEntity();
                readInfoEntity.setGoalType(0);
                readInfoEntity.setMessageId(entity.getId());
                readInfoEntity.setGoalUserId(catEntity.getReceiverId());
                readInfoEntity.setReadFlag(catEntity.getHadReadFlag());
                readInfoEntity.setDeleted(catEntity.getDeleted());
                this.messageReadInfoService.save(readInfoEntity);
                log.info("----\u5bfc\u5165\u5df2\u8bfb\u6d88\u606fid:{}\uff0c\u5b8c\u6210", (Object)readInfoEntity.getId());
            }
        }
        return true;
    }

    public SyncMessageServiceImpl(AdsmediaStationMsgService adsmediaStationMsgService, AdsmediaStationSysMsgStatusService adsmediaStationSysMsgStatusService, CatStationMsgService catStationMsgService, CatStationSysMsgStatusService catStationSysMsgStatusService, MessageInfoService messageInfoService, MessageReadInfoService messageReadInfoService) {
        this.adsmediaStationMsgService = adsmediaStationMsgService;
        this.adsmediaStationSysMsgStatusService = adsmediaStationSysMsgStatusService;
        this.catStationMsgService = catStationMsgService;
        this.catStationSysMsgStatusService = catStationSysMsgStatusService;
        this.messageInfoService = messageInfoService;
        this.messageReadInfoService = messageReadInfoService;
    }
}

