/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.BulkWriteException;
import com.mongodb.WriteConcern;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoExceptionTranslator;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.convert.UpdateMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.Pair;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DefaultBulkOperations
implements BulkOperations {
    private final MongoOperations mongoOperations;
    private final String collectionName;
    private final BulkOperationContext bulkOperationContext;
    private final List<WriteModel<Document>> models = new ArrayList<WriteModel<Document>>();
    private PersistenceExceptionTranslator exceptionTranslator;
    @Nullable
    private WriteConcern defaultWriteConcern;
    private BulkWriteOptions bulkOptions;

    DefaultBulkOperations(MongoOperations mongoOperations, String collectionName, BulkOperationContext bulkOperationContext) {
        Assert.notNull((Object)mongoOperations, (String)"MongoOperations must not be null!");
        Assert.hasText((String)collectionName, (String)"CollectionName must not be null nor empty!");
        Assert.notNull((Object)bulkOperationContext, (String)"BulkOperationContext must not be null!");
        this.mongoOperations = mongoOperations;
        this.collectionName = collectionName;
        this.bulkOperationContext = bulkOperationContext;
        this.exceptionTranslator = new MongoExceptionTranslator();
        this.bulkOptions = DefaultBulkOperations.getBulkWriteOptions(bulkOperationContext.getBulkMode());
    }

    public void setExceptionTranslator(@Nullable PersistenceExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator == null ? new MongoExceptionTranslator() : exceptionTranslator;
    }

    void setDefaultWriteConcern(@Nullable WriteConcern defaultWriteConcern) {
        this.defaultWriteConcern = defaultWriteConcern;
    }

    @Override
    public BulkOperations insert(Object document) {
        Assert.notNull((Object)document, (String)"Document must not be null!");
        if (document instanceof Document) {
            this.models.add((WriteModel<Document>)new InsertOneModel((Object)((Document)document)));
            return this;
        }
        Document sink = new Document();
        this.mongoOperations.getConverter().write(document, sink);
        this.models.add((WriteModel<Document>)new InsertOneModel((Object)sink));
        return this;
    }

    @Override
    public BulkOperations insert(List<? extends Object> documents) {
        Assert.notNull(documents, (String)"Documents must not be null!");
        documents.forEach(this::insert);
        return this;
    }

    @Override
    public BulkOperations updateOne(Query query, Update update) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)update, (String)"Update must not be null!");
        return this.updateOne(Collections.singletonList(Pair.of((Object)query, (Object)update)));
    }

    @Override
    public BulkOperations updateOne(List<Pair<Query, Update>> updates) {
        Assert.notNull(updates, (String)"Updates must not be null!");
        for (Pair<Query, Update> update : updates) {
            this.update((Query)update.getFirst(), (Update)update.getSecond(), false, false);
        }
        return this;
    }

    @Override
    public BulkOperations updateMulti(Query query, Update update) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)update, (String)"Update must not be null!");
        return this.updateMulti(Collections.singletonList(Pair.of((Object)query, (Object)update)));
    }

    @Override
    public BulkOperations updateMulti(List<Pair<Query, Update>> updates) {
        Assert.notNull(updates, (String)"Updates must not be null!");
        for (Pair<Query, Update> update : updates) {
            this.update((Query)update.getFirst(), (Update)update.getSecond(), false, true);
        }
        return this;
    }

    @Override
    public BulkOperations upsert(Query query, Update update) {
        return this.update(query, update, true, true);
    }

    @Override
    public BulkOperations upsert(List<Pair<Query, Update>> updates) {
        for (Pair<Query, Update> update : updates) {
            this.upsert((Query)update.getFirst(), (Update)update.getSecond());
        }
        return this;
    }

    @Override
    public BulkOperations remove(Query query) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        DeleteOptions deleteOptions = new DeleteOptions();
        query.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((DeleteOptions)deleteOptions).collation(arg_0));
        this.models.add((WriteModel<Document>)new DeleteManyModel((Bson)query.getQueryObject(), deleteOptions));
        return this;
    }

    @Override
    public BulkOperations remove(List<Query> removes) {
        Assert.notNull(removes, (String)"Removals must not be null!");
        for (Query query : removes) {
            this.remove(query);
        }
        return this;
    }

    @Override
    public BulkWriteResult execute() {
        try {
            MongoCollection collection = this.mongoOperations.getCollection(this.collectionName);
            if (this.defaultWriteConcern != null) {
                collection = collection.withWriteConcern(this.defaultWriteConcern);
            }
            BulkWriteResult bulkWriteResult = collection.bulkWrite(this.models.stream().map(this::mapWriteModel).collect(Collectors.toList()), this.bulkOptions);
            return bulkWriteResult;
        }
        catch (BulkWriteException o_O) {
            DataAccessException toThrow = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw toThrow == null ? o_O : toThrow;
        }
        finally {
            this.bulkOptions = DefaultBulkOperations.getBulkWriteOptions(this.bulkOperationContext.getBulkMode());
        }
    }

    private BulkOperations update(Query query, Update update, boolean upsert, boolean multi) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)update, (String)"Update must not be null!");
        UpdateOptions options = new UpdateOptions();
        options.upsert(upsert);
        query.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((UpdateOptions)options).collation(arg_0));
        if (multi) {
            this.models.add((WriteModel<Document>)new UpdateManyModel((Bson)query.getQueryObject(), (Bson)update.getUpdateObject(), options));
        } else {
            this.models.add((WriteModel<Document>)new UpdateOneModel((Bson)query.getQueryObject(), (Bson)update.getUpdateObject(), options));
        }
        return this;
    }

    private WriteModel<Document> mapWriteModel(WriteModel<Document> writeModel) {
        if (writeModel instanceof UpdateOneModel) {
            UpdateOneModel model = (UpdateOneModel)writeModel;
            return new UpdateOneModel(this.getMappedQuery(model.getFilter()), this.getMappedUpdate(model.getUpdate()), model.getOptions());
        }
        if (writeModel instanceof UpdateManyModel) {
            UpdateManyModel model = (UpdateManyModel)writeModel;
            return new UpdateManyModel(this.getMappedQuery(model.getFilter()), this.getMappedUpdate(model.getUpdate()), model.getOptions());
        }
        if (writeModel instanceof DeleteOneModel) {
            DeleteOneModel model = (DeleteOneModel)writeModel;
            return new DeleteOneModel(this.getMappedQuery(model.getFilter()), model.getOptions());
        }
        if (writeModel instanceof DeleteManyModel) {
            DeleteManyModel model = (DeleteManyModel)writeModel;
            return new DeleteManyModel(this.getMappedQuery(model.getFilter()), model.getOptions());
        }
        return writeModel;
    }

    private Bson getMappedUpdate(Bson update) {
        return ((QueryMapper)this.bulkOperationContext.getUpdateMapper()).getMappedObject(update, this.bulkOperationContext.getEntity());
    }

    private Bson getMappedQuery(Bson query) {
        return this.bulkOperationContext.getQueryMapper().getMappedObject(query, this.bulkOperationContext.getEntity());
    }

    private static BulkWriteOptions getBulkWriteOptions(BulkOperations.BulkMode bulkMode) {
        BulkWriteOptions options = new BulkWriteOptions();
        switch (bulkMode) {
            case ORDERED: {
                return options.ordered(true);
            }
            case UNORDERED: {
                return options.ordered(false);
            }
        }
        throw new IllegalStateException("BulkMode was null!");
    }

    static final class BulkOperationContext {
        @NonNull
        private final BulkOperations.BulkMode bulkMode;
        @NonNull
        private final Optional<? extends MongoPersistentEntity<?>> entity;
        @NonNull
        private final QueryMapper queryMapper;
        @NonNull
        private final UpdateMapper updateMapper;

        public BulkOperationContext(@NonNull BulkOperations.BulkMode bulkMode, @NonNull Optional<? extends MongoPersistentEntity<?>> entity, @NonNull QueryMapper queryMapper, @NonNull UpdateMapper updateMapper) {
            if (bulkMode == null) {
                throw new IllegalArgumentException("bulkMode is marked @NonNull but is null");
            }
            if (entity == null) {
                throw new IllegalArgumentException("entity is marked @NonNull but is null");
            }
            if (queryMapper == null) {
                throw new IllegalArgumentException("queryMapper is marked @NonNull but is null");
            }
            if (updateMapper == null) {
                throw new IllegalArgumentException("updateMapper is marked @NonNull but is null");
            }
            this.bulkMode = bulkMode;
            this.entity = entity;
            this.queryMapper = queryMapper;
            this.updateMapper = updateMapper;
        }

        @NonNull
        public BulkOperations.BulkMode getBulkMode() {
            return this.bulkMode;
        }

        @NonNull
        public Optional<? extends MongoPersistentEntity<?>> getEntity() {
            return this.entity;
        }

        @NonNull
        public QueryMapper getQueryMapper() {
            return this.queryMapper;
        }

        @NonNull
        public UpdateMapper getUpdateMapper() {
            return this.updateMapper;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BulkOperationContext)) {
                return false;
            }
            BulkOperationContext other = (BulkOperationContext)o;
            BulkOperations.BulkMode this$bulkMode = this.getBulkMode();
            BulkOperations.BulkMode other$bulkMode = other.getBulkMode();
            if (this$bulkMode == null ? other$bulkMode != null : !((Object)((Object)this$bulkMode)).equals((Object)other$bulkMode)) {
                return false;
            }
            Optional<MongoPersistentEntity<?>> this$entity = this.getEntity();
            Optional<? extends MongoPersistentEntity<?>> other$entity = other.getEntity();
            if (this$entity == null ? other$entity != null : !((Object)this$entity).equals(other$entity)) {
                return false;
            }
            QueryMapper this$queryMapper = this.getQueryMapper();
            QueryMapper other$queryMapper = other.getQueryMapper();
            if (this$queryMapper == null ? other$queryMapper != null : !this$queryMapper.equals(other$queryMapper)) {
                return false;
            }
            UpdateMapper this$updateMapper = this.getUpdateMapper();
            UpdateMapper other$updateMapper = other.getUpdateMapper();
            return !(this$updateMapper == null ? other$updateMapper != null : !this$updateMapper.equals(other$updateMapper));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BulkOperations.BulkMode $bulkMode = this.getBulkMode();
            result = result * 59 + ($bulkMode == null ? 43 : ((Object)((Object)$bulkMode)).hashCode());
            Optional<MongoPersistentEntity<?>> $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : ((Object)$entity).hashCode());
            QueryMapper $queryMapper = this.getQueryMapper();
            result = result * 59 + ($queryMapper == null ? 43 : $queryMapper.hashCode());
            UpdateMapper $updateMapper = this.getUpdateMapper();
            result = result * 59 + ($updateMapper == null ? 43 : $updateMapper.hashCode());
            return result;
        }

        public String toString() {
            return "DefaultBulkOperations.BulkOperationContext(bulkMode=" + (Object)((Object)this.getBulkMode()) + ", entity=" + this.getEntity() + ", queryMapper=" + this.getQueryMapper() + ", updateMapper=" + this.getUpdateMapper() + ")";
        }
    }
}

