/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.encoding;

import feign.Client;
import feign.Feign;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.cloud.openfeign.encoding.FeignAcceptGzipEncodingInterceptor;
import org.springframework.cloud.openfeign.encoding.FeignClientEncodingProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={FeignClientEncodingProperties.class})
@ConditionalOnClass(value={Feign.class})
@ConditionalOnBean(value={Client.class})
@ConditionalOnProperty(value={"feign.compression.response.enabled"}, matchIfMissing=false)
@ConditionalOnMissingBean(type={"okhttp3.OkHttpClient"})
@AutoConfigureAfter(value={FeignAutoConfiguration.class})
public class FeignAcceptGzipEncodingAutoConfiguration {
    @Bean
    public FeignAcceptGzipEncodingInterceptor feignAcceptGzipEncodingInterceptor(FeignClientEncodingProperties properties) {
        return new FeignAcceptGzipEncodingInterceptor(properties);
    }
}

