package com.bxm.counter.model.constant.ticket;

/**
 * <p> 广告组统计相关常量 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/8/9
 */
public class AdGroupCounterConstant {
    /**
     * 点击数据保存redis的数据库
     */
    public final static int CLICK_DB_INDEX = 0;

    /**
     * 广告组数据存到 redis 的有效时间
     */
    public final static int AD_SHOP_OUT_SECONDS = 60 * 60 * 24 * 4 *3;

    /**
     * 广告组数据存到 redis 的key的前缀
     */
    public static final String AD_SHOP_TOTAL_KEY = "adShopMsgClickKeys";

    /**
     * 默认类型
     */
    public static final String DEFAULT_MODEL_TYPE = "7";
    /***
     * 默认状态
     */
    public static final String DEFAULT_STATUS = "2";

    /**
     * 广告券点击countInfo发送 mq 消息 code
     */
    public final static int COUNT_TICKET__MSG_CODE = 1;

    /**
     * 广告组countInfo数据发送 mq 消息 code
     */
    public final static int COUNT_GROUP_MSG_CODE = 2;
}
