package com.bxm.datapark.facade.app.model.vo;

import com.bxm.util.dto.VoUtil;

import java.io.Serializable;

import org.apache.commons.lang3.StringUtils;

/**
 * 开发者日报实体
 * @author bcc
 */
public class AppCountVo implements Serializable{


    private static final long serialVersionUID = 1775836443028039200L;
    /**
     * 编号
     */
    private String number;
    /**
     * 日期
     */

    private String datetime;

    /**
     * 开发者唯一标识
     */
    private String appKey;

    /**
     * 开发者唯一标识
     */
    private String business;
    
    /**
     * 广告位ID
     */
    private String positionId;

    /**
     *
     * 广告位点击量
     */

    private Integer iconClickPv;
    
    /**
     * 广告位点击率
     */
    private Double iconClickPvRate;
    
    /**
     * 广告位点击率涨幅,已乘100
     */
    private String iconClickPvRateChange;

    /**
     * 入口点击pv环比昨日，已乘100
     */
    private String iconClickChange;

    /**
     * 中间页uv
     */
    private Integer midPageUv;

    /**
     * 中间页uv环比昨日，已乘100
     */
    private String midUvChange;

    /**
     * 中间页pv(中间页曝光数)  原入口点击数
     */
    private Integer midPagePv;

    /**
     * 中间页pv环比昨日，已乘100
     */
    private String midPvChange;

    /**
     * 活动首页pv
     */
    private Integer indexPv;

    /**
     * 活动首页pv环比昨日，已乘100
     */
    private String indexPvChange;

    /**
     * 活动首页uv
     */
    private Integer indexUv;

    /**
     * 活动首页uv环比昨日，已乘100
     */
    private String indexUvChange;

    private Integer joinUv;

    private Integer clickPv;

    /**
     * 活动参与率
     */
    private Double joinRate;

    /**
     * 活动参与率环比昨日，已乘100
     */
    private String joinRateChange;

    /**
     * 发券请求量
     */
    private Integer sendPv;

    /**
     * 发券请求环比昨日，已乘100
     */
    private String sendPvChange;

    /**
     * 发券量
     */
    private Integer openPv;

    /**
     * 发券量环比昨日，已乘100
     */
    private String openPvChange;

    /**
     * 发券成功率
     */
    private Double successRate;

    /**
     * 发券成功率环比昨日，已乘100
     */
    private String successRateChange;

    /**
     * 安卓发券占比
     */
    private Double androidOpenRate;

    /**
     * 安卓发券占比环比昨日，已乘100
     */
    private String androidRateChange;

    /**
     * ios发券占比
     */
    private Double iosOpenRate;

    /**
     * ios发券占比环比昨日，已乘100
     */
    private String iosRateChange;

    /**
     * web发券占比
     */
    private Double webOpenRate;

    /**
     * web发券占比环比昨日，已乘100
     */
    private String webRateChange;

    /**
     * 微信发券占比
     */
    private Double wechatOpenRate;

    /**
     * 微信发券占比环比昨日，已乘100
     */
    private String wechatRateChange;

    /**
     * IMEI发券占比
     */
    private Double imeiOpenRate;

    /**
     * IMEI发券占比环比昨日，已乘100
     */
    private String imeiRateChange;

    /**
     * 老用户占比（当日uv中在前三天有访问记录的uv记为老用户）
     */
    private Double oldRate;

    /**
     * 老用户占比环比昨日，已乘100
     */
    private String oldRateChange;

    /**
     * 广告券点击率
     */
    private Double clickRate;

    /**
     * 广告券点击率环比昨日，已乘100
     */
    private String clickRateChange;

    /**
     * 人均发券量
     */
    private Double perOpenPv;

    /**
     * 人均发券环比昨日，已乘100
     */
    private String perOpenPvChange;

    /**
     * 人均重复发券
     */
    private Double rptOpenPv;

    /**
     * 人均重复发券环比昨日，已乘100
     */
    private String rptOpenPvChange;

    /**
     * 券收入
     */
    private Double income;

    /**
     * 券收入涨幅
     */
    private String incomeChange;
    /**
     * 开发者收益
     */
    private Double developerIncome;
    /**
     * 开发者收益涨幅
     */
    private String developerIncomeChange;
    /**
     * 变现猫收益
     */
    private Double bxmIncome;
    /**
     * 变现猫收益涨幅
     */
    private String bxmIncomeChange;
    /**
     * 发券ARUP(券收入除以发券量)
     */
    private Double openPvAurp;
    /**
     * 发券ARUP涨幅
     */
    private String openPvAurpChange;
    /**
     * UVARUP
     */
    private Double uvAurp;
    /**
     * UVARUP涨幅
     */
    private String uvAurpChange;
    /**
     * 开发者UVARUP
     */
    private Double developerAurp;
    /**
     * 开发者UVARUP涨幅
     */
    private String developerAurpChange;
    /**
     * 变现猫UVARUP
     */
    private Double bxmAurp;
    /**
     * 变现猫UVARUP涨幅
     */
    private String bxmAurpChange;
    /**
     * 子链接收益（排序）
     */
    private Double businessIncome;
    /**
     * 子链接收益涨幅
     */
    private String businessIncomeChange;
    /**
     * 子链接 UVAURP
     */
    private Double businessAurp;
    /**
     * 子链接 UVAURP 涨幅
     */
    private String businessAurpChange;

    /**
     * 券收入 UVAURP
     */
    private Double incomeAurp;
    /**
     * 券收入 UVAURP 涨幅
     */
    private String incomeAurpChange;

    /**
     * 广告位曝光数
     */
    private Integer iconPv;

    /**
     * 广告位曝光数涨幅
     */
    private String iconChange;

    /**
     * 点击到达率
     */
    private Double midPageRate;

    /**
     * 点击到达率涨幅
     * */
    private String midPageRateChange;

    /**
     * 首页曝光数
     * */
    private Integer  landingPagePv;

    /**
     * 首页曝光数涨幅
     * */
    private String landingPageChange;

    /**
     * 页面展现率
     * */
    private Double landingPageRate;

    /**
     * 页面展现率涨幅
     * */
    private String landingRateChange;


    /**
     * ecpm（券收入除以广告位曝光数）
     * */
    private Double ecpm;

    /**
     * ecpm涨幅
     * */
    private String ecpmChange;

    /**
     * mEcpm 媒体ecpm（子链接收益除以广告位曝光数）
     * */
    private Double mEcpm;

    /**
     * mEcpm涨幅
     * */
    private String mEcpmChange;
    /**
     * 人均点击量=人均券点击
     */
    private Double  perClickPv;

    /**
     * 人均点击量环比昨日
     */
    private Double  perClickPvChange;
    /**
     *子链接UVarpu
     * */
    private Double bussinessUvArpu;
    
    /**
     *子链接UVarpu
     * */
    private String bussinessUvArpuChange;

    /**
     *券收入UVArpu
     * */
    private Double incomeUvArpu;

    public String getDatetime() {
        return datetime;
    }

    public String getAppKey() {
        return appKey;
    }

    public String getBusiness() {
        return business;
    }

    public Integer getIconClickPv() {
        return iconClickPv;
    }

    public String getIconClickChange() {
        return VoUtil.percentage(iconClickChange);
    }



    public String getMidUvChange() {
        return VoUtil.percentage(midUvChange);
    }

    public String getMidPvChange() {
        return VoUtil.percentage(midPvChange);
    }

    public Integer getIndexPv() {
        return indexPv;
    }

    public String getIndexPvChange() {
        return VoUtil.percentage(indexPvChange);
    }

    public Integer getIndexUv() {
        return indexUv;
    }

    public String getIndexUvChange() {
        return VoUtil.percentage(indexUvChange);
    }

    public Double getJoinRate() {
        return joinRate;
    }

    public String getJoinRateChange() {
        return VoUtil.percentage(joinRateChange);
    }

    public Integer getSendPv() {
        return sendPv;
    }

    public String getSendPvChange() {
        return VoUtil.percentage(sendPvChange);
    }

    public Integer getOpenPv() {
        return openPv;
    }

    public String getOpenPvChange() {
        return VoUtil.percentage(openPvChange);
    }

    public Double getSuccessRate() {
        return successRate;
    }

    public String getSuccessRateChange() {
        return VoUtil.percentage(successRateChange);
    }

    public Double getAndroidOpenRate() {
        return androidOpenRate;
    }

    public String getAndroidRateChange() {
        return VoUtil.percentage(androidRateChange);
    }

    public Double getIosOpenRate() {
        return iosOpenRate;
    }

    public String getIosRateChange() {
        return VoUtil.percentage(iosRateChange);
    }

    public Double getWebOpenRate() {
        return webOpenRate;
    }

    public String getWebRateChange() {
        return VoUtil.percentage(webRateChange);
    }

    public Double getWechatOpenRate() {
        return wechatOpenRate;
    }

    public String getWechatRateChange() {
        return VoUtil.percentage(wechatRateChange);
    }

    public Double getImeiOpenRate() {
        return imeiOpenRate;
    }

    public String getImeiRateChange() {
        return VoUtil.percentage(imeiRateChange);
    }

    public Double getOldRate() {
        return oldRate;
    }

    public String getOldRateChange() {
        return VoUtil.percentage(oldRateChange);
    }

    public Double getClickRate() {
        return clickRate;
    }

    public String getClickRateChange() {
        return VoUtil.percentage(clickRateChange);
    }

    public Double getPerOpenPv() {
        return perOpenPv;
    }

    public String getPerOpenPvChange() {
        return VoUtil.percentage(perOpenPvChange);
    }

    public Double getRptOpenPv() {
        return rptOpenPv;
    }

    public String getRptOpenPvChange() {
        return VoUtil.percentage(rptOpenPvChange);
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public void setIconClickPv(Integer iconClickPv) {
        this.iconClickPv = iconClickPv;
    }

    public void setIconClickChange(String iconClickChange) {
        this.iconClickChange = iconClickChange;
    }

    public Integer getMidPageUv() {
        return midPageUv;
    }

    public void setMidPageUv(Integer midPageUv) {
        this.midPageUv = midPageUv;
    }

    public Integer getMidPagePv() {
        return midPagePv;
    }

    public void setMidUvChange(String midUvChange) {
        this.midUvChange = midUvChange;
    }

    public void setMidPagePv(Integer midPagePv) {
        this.midPagePv = midPagePv;
    }

    public void setMidPvChange(String midPvChange) {
        this.midPvChange = midPvChange;
    }

    public void setIndexPv(Integer indexPv) {
        this.indexPv = indexPv;
    }

    public void setIndexPvChange(String indexPvChange) {
        this.indexPvChange = indexPvChange;
    }

    public void setIndexUv(Integer indexUv) {
        this.indexUv = indexUv;
    }

    public void setIndexUvChange(String indexUvChange) {
        this.indexUvChange = indexUvChange;
    }

    public void setJoinRate(Double joinRate) {
        this.joinRate = joinRate;
    }

    public void setJoinRateChange(String joinRateChange) {
        this.joinRateChange = joinRateChange;
    }

    public void setSendPv(Integer sendPv) {
        this.sendPv = sendPv;
    }

    public void setSendPvChange(String sendPvChange) {
        this.sendPvChange = sendPvChange;
    }

    public void setOpenPv(Integer openPv) {
        this.openPv = openPv;
    }

    public void setOpenPvChange(String openPvChange) {
        this.openPvChange = openPvChange;
    }

    public void setSuccessRate(Double successRate) {
        this.successRate = successRate;
    }

    public void setSuccessRateChange(String successRateChange) {
        this.successRateChange = successRateChange;
    }

    public void setAndroidOpenRate(Double androidOpenRate) {
        this.androidOpenRate = androidOpenRate;
    }

    public void setAndroidRateChange(String androidRateChange) {
        this.androidRateChange = androidRateChange;
    }

    public void setIosOpenRate(Double iosOpenRate) {
        this.iosOpenRate = iosOpenRate;
    }

    public void setIosRateChange(String iosRateChange) {
        this.iosRateChange = iosRateChange;
    }

    public void setWebOpenRate(Double webOpenRate) {
        this.webOpenRate = webOpenRate;
    }

    public void setWebRateChange(String webRateChange) {
        this.webRateChange = webRateChange;
    }

    public void setWechatOpenRate(Double wechatOpenRate) {
        this.wechatOpenRate = wechatOpenRate;
    }

    public void setWechatRateChange(String wechatRateChange) {
        this.wechatRateChange = wechatRateChange;
    }

    public void setImeiOpenRate(Double imeiOpenRate) {
        this.imeiOpenRate = imeiOpenRate;
    }

    public void setImeiRateChange(String imeiRateChange) {
        this.imeiRateChange = imeiRateChange;
    }

    public void setOldRate(Double oldRate) {
        this.oldRate = oldRate;
    }

    public void setOldRateChange(String oldRateChange) {
        this.oldRateChange = oldRateChange;
    }

    public void setClickRate(Double clickRate) {
        this.clickRate = clickRate;
    }

    public void setClickRateChange(String clickRateChange) {
        this.clickRateChange = clickRateChange;
    }

    public void setPerOpenPv(Double perOpenPv) {
        this.perOpenPv = perOpenPv;
    }

    public void setPerOpenPvChange(String perOpenPvChange) {
        this.perOpenPvChange = perOpenPvChange;
    }

    public void setRptOpenPv(Double rptOpenPv) {
        this.rptOpenPv = rptOpenPv;
    }

    public void setRptOpenPvChange(String rptOpenPvChange) {
        this.rptOpenPvChange = rptOpenPvChange;
    }

    public void setIncome(Double income) {
        this.income = income;
    }

    public void setIncomeChange(String incomeChange) {
        this.incomeChange = incomeChange;
    }

    public void setDeveloperIncome(Double developerIncome) {
        this.developerIncome = developerIncome;
    }

    public void setDeveloperIncomeChange(String developerIncomeChange) {
        this.developerIncomeChange = developerIncomeChange;
    }

    public void setBxmIncome(Double bxmIncome) {
        this.bxmIncome = bxmIncome;
    }

    public void setBxmIncomeChange(String bxmIncomeChange) {
        this.bxmIncomeChange = bxmIncomeChange;
    }

    public void setOpenPvAurp(Double openPvAurp) {
        this.openPvAurp = openPvAurp;
    }

    public void setOpenPvAurpChange(String openPvAurpChange) {
        this.openPvAurpChange = openPvAurpChange;
    }

    public void setUvAurp(Double uvAurp) {
        this.uvAurp = uvAurp;
    }

    public void setUvAurpChange(String uvAurpChange) {
        this.uvAurpChange = uvAurpChange;
    }

    public void setDeveloperAurp(Double developerAurp) {
        this.developerAurp = developerAurp;
    }

    public void setDeveloperAurpChange(String developerAurpChange) {
        this.developerAurpChange = developerAurpChange;
    }

    public void setBxmAurp(Double bxmAurp) {
        this.bxmAurp = bxmAurp;
    }

    public void setBxmAurpChange(String bxmAurpChange) {
        this.bxmAurpChange = bxmAurpChange;
    }

    public void setBusinessIncome(Double businessIncome) {
        this.businessIncome = businessIncome;
    }

    public void setBusinessIncomeChange(String businessIncomeChange) {
        this.businessIncomeChange = businessIncomeChange;
    }

    public void setBusinessAurp(Double businessAurp) {
        this.businessAurp = businessAurp;
    }

    public void setBusinessAurpChange(String businessAurpChange) {
        this.businessAurpChange = businessAurpChange;
    }


    public Double getIncome() {
        return income;
    }

    public String getIncomeChange() {
        return VoUtil.percentage(incomeChange);
    }

    public Double getDeveloperIncome() {
        return developerIncome;
    }

    public String getDeveloperIncomeChange() {
        return VoUtil.percentage(developerIncomeChange);
    }

    public Double getBxmIncome() {
        return bxmIncome;
    }

    public String getBxmIncomeChange() {
        return VoUtil.percentage(bxmIncomeChange);
    }

    public Double getOpenPvAurp() {
        return openPvAurp;
    }

    public String getOpenPvAurpChange() {
        return VoUtil.percentage(openPvAurpChange);
    }

    public Double getUvAurp() {
        return uvAurp;
    }

    public String getUvAurpChange() {
        return VoUtil.percentage(uvAurpChange);
    }

    public Double getDeveloperAurp() {
        return developerAurp;
    }

    public String getDeveloperAurpChange() {
        return VoUtil.percentage(developerAurpChange);
    }

    public Double getBxmAurp() {
        return bxmAurp;
    }

    public String getBxmAurpChange() {
        return VoUtil.percentage(bxmAurpChange);
    }

    public Double getBusinessIncome() {
        return businessIncome;
    }

    public String getBusinessIncomeChange() {
        return VoUtil.percentage(businessIncomeChange);
    }

    public Double getBusinessAurp() {
        return businessAurp;
    }

    public String getBusinessAurpChange() {
        return VoUtil.percentage(businessAurpChange);
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Integer getJoinUv() {
        return joinUv;
    }

    public void setJoinUv(Integer joinUv) {
        this.joinUv = joinUv;
    }

    public Integer getClickPv() {
        return clickPv;
    }

    public void setClickPv(Integer clickPv) {
        this.clickPv = clickPv;
    }

    public Double getIncomeAurp() {
        return VoUtil.getArpuOrEcpm(income,indexUv);
    }

    public void setIncomeAurp(Double incomeAurp) {
        this.incomeAurp = incomeAurp;
    }

    public String getIncomeAurpChange() {
        return incomeAurpChange;
    }

    public void setIncomeAurpChange(String incomeAurpChange) {
        this.incomeAurpChange = incomeAurpChange;
    }

    public Integer getIconPv() {
        return iconPv;
    }

    public void setIconPv(Integer iconPv) {
        this.iconPv = iconPv;
    }

    public Double getMidPageRate() {
        return midPageRate;
    }

    public void setMidPageRate(Double midPageRate) {
        this.midPageRate = midPageRate;
    }

    public Integer getLandingPagePv() {
        return landingPagePv;
    }

    public void setLandingPagePv(Integer landingPagePv) {
        this.landingPagePv = landingPagePv;
    }

    public Double getLandingPageRate() {
        return landingPageRate;
    }

    public void setLandingPageRate(Double landingPageRate) {
        this.landingPageRate = landingPageRate;
    }
    //券收入除以广告位曝光数
    public Double getEcpm() {
        return VoUtil.getArpuOrEcpm(income,iconPv)*1000;
    }

    public void setEcpm(Double ecpm) {
        this.ecpm = ecpm;
    }
    //子链接收益除以广告位曝光数
    public Double getmEcpm() {
        return VoUtil.getArpuOrEcpm(businessIncome,iconPv)*1000;
    }

    public void setmEcpm(Double mEcpm) {
        this.mEcpm = mEcpm;
    }

    public String getIconChange() {
        return VoUtil.percentage(incomeChange);
    }

    public void setIconChange(String iconChange) {
        this.iconChange = iconChange;
    }

    public String getMidPageRateChange() {
        return midPageRateChange;
    }

    public void setMidPageRateChange(String midPageRateChange) {
        this.midPageRateChange = midPageRateChange;
    }

    public String getLandingPageChange() {
        return VoUtil.percentage(landingPageChange);
    }

    public void setLandingPageChange(String landingPageChange) {
        this.landingPageChange = landingPageChange;
    }

    public String getLandingRateChange() {
        return landingRateChange;
    }

    public void setLandingRateChange(String landingRateChange) {
        this.landingRateChange = landingRateChange;
    }

    public String getEcpmChange() {
        return VoUtil.percentage(ecpmChange);
    }

    public void setEcpmChange(String ecpmChange) {
        this.ecpmChange = ecpmChange;
    }

    public String getmEcpmChange() {
        return VoUtil.percentage(ecpmChange);
    }

    public void setmEcpmChange(String mEcpmChange) {
        this.mEcpmChange = mEcpmChange;
    }
    //子链接uvArpu = 子链接收益/活动首页uv
    public Double getBussinessUvArpu() {
        return VoUtil.getArpuOrEcpm(businessIncome,indexUv);
    }

    public void setBussinessUvArpu(Double bussinessUvArpu) {
        this.bussinessUvArpu = bussinessUvArpu;
    }
    //券收入uvArpu = 券收入/活动首页uv
    public Double getIncomeUvArpu() {
        return VoUtil.getArpuOrEcpm(income,indexUv);
    }

    public void setIncomeUvArpu(Double incomeUvArpu) {
        this.incomeUvArpu = incomeUvArpu;
    }

    public Double getPerClickPv() {
        return perClickPv;
    }

    public void setPerClickPv(Double perClickPv) {
        this.perClickPv = perClickPv;
    }

    public Double getPerClickPvChange() {
        return perClickPvChange;
    }

    public void setPerClickPvChange(Double perClickPvChange) {
        this.perClickPvChange = perClickPvChange;
    }

    public Double getIconClickPvRate() {
        return iconClickPvRate;
    }

    public void setIconClickPvRate(Double iconClickPvRate) {
        this.iconClickPvRate = iconClickPvRate;
    }

    public String getIconClickPvRateChange() {
        return VoUtil.percentage(iconClickPvRateChange);
    }

    public void setIconClickPvRateChange(String iconClickPvRateChange) {
        this.iconClickPvRateChange = iconClickPvRateChange;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getBussinessUvArpuChange() {
        return VoUtil.percentage(bussinessUvArpuChange);
    }

    public void setBussinessUvArpuChange(String bussinessUvArpuChange) {
        this.bussinessUvArpuChange = bussinessUvArpuChange;
    }
    
}
