package com.bxm.datapark.facade.order.model.vo;

import java.io.Serializable;

import org.springframework.data.mongodb.core.mapping.Field;

/**
* @Title:BusinessOrder.java
* @Package:com.bxm.datapark.model.mongo.vo.newad
* @Description: 货到付款订单
 */
public class BusinessOrderVo implements Serializable {

    private static final long serialVersionUID = -3940236160943924494L;

    /**
     *广告ID
     */
    @Field("certificate_id")
    private Long certificateId;
    
    /**
     * 广告名称
     */
    @Field("shopsname")
    private String shopsname;
    
    /**
     * 媒体名称
     */
    @Field("app_name")
    private String appName;
    
    /**
     * 广告位名称
     */
    @Field("app_entrance_name")
    private String appEntranceName;
    
    /**
     * 广告位ID
     */
    @Field("positionid")
    private String positionId;
    
    /**
     * 订单数
     */
    @Field("order_quanlity")
    private Double orderQuantity;
    
    /**
     * 待发货数
     */
    @Field("pending_delivery")
    private Double pendingDelivery;
    
    /**
     * 在途数
     */
    @Field("in_transit")
    private Double inTransit;
    
    /**
     * 签收
     */
    @Field("sign_in")
    private Double signin;
    
    /**
     * 退回数
     */
    @Field("return")
    private Double returnNum;
    
    /**
     * 取消发货数
     */
    @Field("cancel_delivery")
    private Double cancelDelivery;
    
    /**
     * 签收率
     */
    @Field("sign_in_rate")
    private Double signinRate;
    private String signinRateStr;
    
    /**
     * 退回率
     */
    @Field("return_rate")
    private Double returnRate;
    private String returnRateStr;
    /**
     * 取消率
     */
    @Field("cancel_rate")
    private Double cancelRate;
    private String cancelRateStr;
    
    @Field("date_time")
    private String dateTime;
    
    public String getDateTime() {
        return dateTime;
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    public Long getCertificateId() {
        return certificateId;
    }

    public void setCertificateId(Long certificateId) {
        this.certificateId = certificateId;
    }

    public String getShopsname() {
        return shopsname;
    }

    public void setShopsname(String shopsname) {
        this.shopsname = shopsname;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppEntranceName() {
        return appEntranceName;
    }

    public void setAppEntranceName(String appEntranceName) {
        this.appEntranceName = appEntranceName;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public Double getOrderQuantity() {
        return orderQuantity;
    }

    public void setOrderQuantity(Double orderQuantity) {
        this.orderQuantity = orderQuantity;
    }

    public Double getPendingDelivery() {
        return pendingDelivery;
    }

    public void setPendingDelivery(Double pendingDelivery) {
        this.pendingDelivery = pendingDelivery;
    }

    public Double getInTransit() {
        return inTransit;
    }

    public void setInTransit(Double inTransit) {
        this.inTransit = inTransit;
    }

    public Double getSignin() {
        return signin;
    }

    public void setSignin(Double signin) {
        this.signin = signin;
    }

    public Double getReturnNum() {
        return returnNum;
    }

    public void setReturnNum(Double returnNum) {
        this.returnNum = returnNum;
    }

    public Double getCancelDelivery() {
        return cancelDelivery;
    }

    public void setCancelDelivery(Double cancelDelivery) {
        this.cancelDelivery = cancelDelivery;
    }

    public Double getSigninRate() {
        return signinRate;
    }

    public void setSigninRate(Double signinRate) {
        this.signinRate = signinRate;
    }

    public Double getReturnRate() {
        return returnRate;
    }

    public void setReturnRate(Double returnRate) {
        this.returnRate = returnRate;
    }

    public Double getCancelRate() {
        return cancelRate;
    }

    public void setCancelRate(Double cancelRate) {
        this.cancelRate = cancelRate;
    }

    public String getSigninRateStr() {
        return signinRateStr = signinRate !=null?(signinRate +"%"):"0.0%";
    }


    public String getReturnRateStr() {
        return returnRateStr = returnRate !=null?(returnRate +"%"):"0.0%";
    }

    public String getCancelRateStr() {
        return cancelRateStr = cancelRate !=null?(cancelRate +"%"):"0.0%";
    }

    public void setSigninRateStr(String signinRateStr) {
        this.signinRateStr = signinRateStr;
    }

    public void setReturnRateStr(String returnRateStr) {
        this.returnRateStr = returnRateStr;
    }

    public void setCancelRateStr(String cancelRateStr) {
        this.cancelRateStr = cancelRateStr;
    }
    
    
}
