package com.bxm.datapark.facade.position.model.vo;

import java.io.Serializable;

import org.springframework.data.mongodb.core.mapping.Field;

/**
* @Title:PositionUserPortrait.java
* @Package:com.bxm.datapark.model.mongo.vo.position
* @Description: 广告位用户画像实体类
* @date:2018年8月8日 下午6:39:22
 */
public class PositionUserPortraitVo implements Serializable{

    
    private static final long serialVersionUID = 7456980860558064520L;

    /**
     * 广告位ID
     */
    @Field("positionid")
    private String positionId;
    
    /**
     * 媒体名称
     */
    @Field("app_name")
    private String appName;
    
    /**
     * 广告位名称
     */
    @Field("app_entrance_name")
    private String appEntranceName;
    
    /**
     * 年龄样本数
     */
    @Field("age_sample_size")
    private Double ageSampleSize = 0d;
    
    /**
     * <18占比
     */
    @Field("under_18_proportion")
    private Double proportionUnder18 = 0d;
    private String proportionUnder18Str;
    
    /**
     * 18-22占比
     */
    @Field("18_22_proportion")
    private Double proportion18between22 = 0d;
    private String proportion18between22Str;
    
    /**
     * 23-50占比
     */
    @Field("23_50_proportion")
    private Double proportion23between50 = 0d;
    private String proportion23between50Str;
    
    /**
     * 50以上占比
     */
    @Field("over_50_proportion")
    private Double proportionOver50 = 0d;
    private String proportionOver50Str;
    
    /**
     * 职业样本数
     */
    @Field("occupation_sample_size")
    private Double occupationSampleSize = 0d;
    
    /**
     * 学生占比
     */
    @Field("student_proportion")
    private Double studentProportion = 0d;
    private String studentProportionStr;
    
    /**
     * 上班占比
     */
    @Field("work_proportion")
    private Double workProportion = 0d;
    private String workProportionStr;
    
    /**
     * 待业占比
     */
    @Field("unemployedu_proportion")
    private Double proportionUnemployedu = 0d;
    private String proportionUnemployeduStr;
    
    private String dateTime;
    
    private String number;
    
    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getDateTime() {
        return dateTime;
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppEntranceName() {
        return appEntranceName;
    }

    public void setAppEntranceName(String appEntranceName) {
        this.appEntranceName = appEntranceName;
    }

    public Double getAgeSampleSize() {
        return ageSampleSize;
    }

    public void setAgeSampleSize(Double ageSampleSize) {
        this.ageSampleSize = ageSampleSize;
    }

    public Double getProportionUnder18() {
        return proportionUnder18;
    }

    public void setProportionUnder18(Double proportionUnder18) {
        this.proportionUnder18 = proportionUnder18;
    }

    public Double getProportion18between22() {
        return proportion18between22;
    }

    public void setProportion18between22(Double proportion18between22) {
        this.proportion18between22 = proportion18between22;
    }
    
    public Double getProportion23between50() {
        return proportion23between50;
    }

    public void setProportion23between50(Double proportion23between50) {
        this.proportion23between50 = proportion23between50;
    }

    public Double getProportionOver50() {
        return proportionOver50;
    }

    public void setProportionOver50(Double proportionOver50) {
        this.proportionOver50 = proportionOver50;
    }

    public Double getOccupationSampleSize() {
        return occupationSampleSize;
    }

    public void setOccupationSampleSize(Double occupationSampleSize) {
        this.occupationSampleSize = occupationSampleSize;
    }

    public Double getStudentProportion() {
        return studentProportion;
    }

    public void setStudentProportion(Double studentProportion) {
        this.studentProportion = studentProportion;
    }

    public Double getWorkProportion() {
        return workProportion;
    }

    public void setWorkProportion(Double workProportion) {
        this.workProportion = workProportion;
    }

    public Double getProportionUnemployedu() {
        return proportionUnemployedu;
    }

    public void setProportionUnemployedu(Double proportionUnemployedu) {
        this.proportionUnemployedu = proportionUnemployedu;
    }
    /***************************************************/
    public String getProportionUnder18Str() {
        return proportionUnder18Str = proportionUnder18 !=null?(proportionUnder18 +"%"):"0.0%";
    }

    public String getProportion18between22Str() {
        return proportion18between22Str = proportion18between22 !=null?(proportion18between22 +"%"):"0.0%";
    }

    public String getProportion23between50Str() {
        return proportion23between50Str = proportion23between50 !=null?(proportion23between50 +"%"):"0.0%";
    }


    public String getProportionOver50Str() {
        return proportionOver50Str = proportionOver50 !=null?(proportionOver50 +"%"):"0.0%";
    }

    public String getStudentProportionStr() {
        return studentProportionStr = studentProportion !=null?(studentProportion +"%"):"0.0%";
    }

    public String getWorkProportionStr() {
        return workProportionStr = workProportion !=null?(workProportion +"%"):"0.0%";
    }

    public String getProportionUnemployeduStr() {
        return proportionUnemployeduStr = proportionUnemployedu !=null?(proportionUnemployedu +"%"):"0.0%";
    }

    public void setProportionUnder18Str(String proportionUnder18Str) {
        this.proportionUnder18Str = proportionUnder18Str;
    }

    public void setProportion18between22Str(String proportion18between22Str) {
        this.proportion18between22Str = proportion18between22Str;
    }

    public void setProportion23between50Str(String proportion23between50Str) {
        this.proportion23between50Str = proportion23between50Str;
    }

    public void setProportionOver50Str(String proportionOver50Str) {
        this.proportionOver50Str = proportionOver50Str;
    }

    public void setStudentProportionStr(String studentProportionStr) {
        this.studentProportionStr = studentProportionStr;
    }

    public void setWorkProportionStr(String workProportionStr) {
        this.workProportionStr = workProportionStr;
    }

    public void setProportionUnemployeduStr(String proportionUnemployeduStr) {
        this.proportionUnemployeduStr = proportionUnemployeduStr;
    }
    
}
