package com.bxm.datapark.facade.ticket.model.vo;

import org.springframework.data.mongodb.core.mapping.Field;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * Created by wuwenquan on 2018/8/25.
 */
public class SendTicketDetailVo {
    //广告券Id
    @Field("certificate_id")
    private Long  certificateId;
    //时间
    private String  dateTime;
    //发券量
    @Field("open_pv")
    private Double openPv;
    //发券量涨幅
    @Field("open_pv_change")
    private Double openPvChange;
    //点击率
    @Field("click_rate")
    private Double clickRate;
    //点击率涨幅
    @Field("click_rate_change")
    private Double clickRateChange;
    //发券arpu
    @Field("open_pv_arpu")
    private Double openPvArpu;
    //发券arpu涨幅
    @Field("open_pv_arpu_change")
    private Double openPvArpuChange;
    //发券占比
    @Field("certificate_open_rate")
    private Double certificateOpenRate;
    //发券占比涨幅
    @Field("certificate_openrate_change")
    private Double certificateOpenRateChange;
    //总发券机会
    @Field("total_opening_chance")
    private Double totalOpeningChance;
    //总发券机会涨幅
    @Field("total_opening_chance_change")
    private Double totalOpeningChanceChange;
    //点击均价
    private Double perPriceClick;
    //点击均价涨幅
    private Double perPriceClickChange;
    //发券arpu*发券占比
    private Double openPvArpuAndRate;
    //发券arpu*发券占比涨幅
    private Double openPvArpuAndRateChange;

    //波动贡献
    private Double waveContribution;
    //券消耗
    @Field("consume")
    private Double consume;
    //券点击
    @Field("click_pv")
    private Double clickPv;
    //前一日数据
    private SendTicketDetailVo sendTicketDetailVoBefore;
    //券名称
    private String ticketName;
    //结算方式
    private String settleType;

    public String getTicketName() {
        return ticketName;
    }

    public void setTicketName(String ticketName) {
        this.ticketName = ticketName;
    }

    public String getSettleType() {
        return settleType;
    }

    public void setSettleType(String settleType) {
        this.settleType = settleType;
    }

    public SendTicketDetailVo getSendTicketDetailVoBefore() {
        return sendTicketDetailVoBefore;
    }

    public void setSendTicketDetailVoBefore(SendTicketDetailVo sendTicketDetailVoBefore) {
        this.sendTicketDetailVoBefore = sendTicketDetailVoBefore;
    }

    public Long getCertificateId() {
        return certificateId;
    }

    public void setCertificateId(Long certificateId) {
        this.certificateId = certificateId;
    }

    public String getDateTime() {
        return dateTime;
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    public Double getOpenPv() {
        return  null==openPv?0:openPv;
    }

    public void setOpenPv(Double openPv) {
        this.openPv = openPv;
    }

    public Double getClickRate() {
        return null==clickRate?0:clickRate;
    }

    public void setClickRate(Double clickRate) {
        this.clickRate = clickRate;
    }

    public Double getOpenPvArpu() {
        return null==openPvArpu?0:openPvArpu;
    }

    public void setOpenPvArpu(Double openPvArpu) {
        this.openPvArpu = openPvArpu;
    }

    public Double getCertificateOpenRate() {
        return null==certificateOpenRate?0:certificateOpenRate;
    }

    public void setCertificateOpenRate(Double certificateOpenRate) {
        this.certificateOpenRate = certificateOpenRate;
    }

    public Double getTotalOpeningChance() {
        return null==totalOpeningChance?0:totalOpeningChance;
    }

    public void setTotalOpeningChance(Double totalOpeningChance) {
        this.totalOpeningChance = totalOpeningChance;
    }

    public Double getPerPriceClick() {
        return div(this.consume,this.clickPv,2);
    }

    public void setPerPriceClick(Double perPriceClick) {
        this.perPriceClick = perPriceClick;
    }

    public Double getOpenPvArpuAndRate() {
        return div(mul(this.openPvArpu,this.certificateOpenRate),100d,4);
    }

    public void setOpenPvArpuAndRate(Double openPvArpuAndRate) {
        this.openPvArpuAndRate = openPvArpuAndRate;
    }

    public Double getWaveContribution() {
        return null==waveContribution?0:waveContribution;
    }

    public void setWaveContribution(Double waveContribution) {
        this.waveContribution = waveContribution;
    }

    public Double getConsume() {
        return null==consume?0:consume;
    }

    public void setConsume(Double consume) {
        this.consume = consume;
    }

    public Double getClickPv() {
        return null==clickPv?0:clickPv;
    }

    public void setClickPv(Double clickPv) {
        this.clickPv = clickPv;
    }

    public Double getPerPriceClickChange() {
        return null==perPriceClickChange?0:perPriceClickChange;
    }

    public void setPerPriceClickChange(Double perPriceClickChange) {
        this.perPriceClickChange = perPriceClickChange;
    }

    public Double getOpenPvChange() {
        return null==openPvChange?0:openPvChange;
    }

    public void setOpenPvChange(Double openPvChange) {
        this.openPvChange = openPvChange;
    }

    public Double getClickRateChange() {
        return null==clickRateChange?0:clickRateChange;
    }

    public void setClickRateChange(Double clickRateChange) {
        this.clickRateChange = clickRateChange;
    }

    public Double getOpenPvArpuChange() {
        return null==openPvArpuChange?0:openPvArpuChange;
    }

    public void setOpenPvArpuChange(Double openPvArpuChange) {
        this.openPvArpuChange = openPvArpuChange;
    }

    public Double getCertificateOpenRateChange() {
        return null==certificateOpenRateChange?0:certificateOpenRateChange;
    }

    public void setCertificateOpenRateChange(Double certificateOpenRateChange) {
        this.certificateOpenRateChange = certificateOpenRateChange;
    }

    public Double getTotalOpeningChanceChange() {
        return null==totalOpeningChanceChange?0:totalOpeningChanceChange;
    }

    public void setTotalOpeningChanceChange(Double totalOpeningChanceChange) {
        this.totalOpeningChanceChange = totalOpeningChanceChange;
    }

    public Double getOpenPvArpuAndRateChange() {
        return null==openPvArpuAndRateChange?0:saveTwoPoint(openPvArpuAndRateChange.doubleValue());
    }

    public void setOpenPvArpuAndRateChange(Double openPvArpuAndRateChange) {
        this.openPvArpuAndRateChange = openPvArpuAndRateChange;
    }

    private double saveTwoPoint(double data){
        //如果不需要四舍五入，可以使用RoundingMode.DOWN
        BigDecimal bg = new BigDecimal(data).setScale(2, RoundingMode.UP);
        return bg.doubleValue();
    }
    /**
     * 两个Double数相加
     * @param v1
     * @param v2
     * @return Double
     */
    public static Double add(Double v1,Double v2){
        BigDecimal b1 = new BigDecimal(v1.toString());
        BigDecimal b2 = new BigDecimal(v2.toString());
        return b1.add(b2).doubleValue();
    }

    /**
     * 两个Double数相减
     * @param v1
     * @param v2
     * @return Double
     */
    public static Double sub(Double v1,Double v2){
        BigDecimal b1 = new BigDecimal(v1.toString());
        BigDecimal b2 = new BigDecimal(v2.toString());
        return b1.subtract(b2).doubleValue();
    }

    /**
     * 两个Double数相乘
     * @param v1
     * @param v2
     * @return Double
     */
    public static Double mul(Double v1,Double v2){
        if (null==v1||null==v2){
            return 0D;
        }
        BigDecimal b1 = new BigDecimal(v1.toString());
        BigDecimal b2 = new BigDecimal(v2.toString());
        return b1.multiply(b2).doubleValue();
    }


    /**
     * 两个Double数相除，并保留scale位小数
     * @param v1
     * @param v2
     * @param scale
     * @return Double
     */
    public static Double div(Double v1,Double v2,int scale){
        if (null==v1||null==v2||v2==0){
            return 0D;
        }
        if(scale<0){
            throw new IllegalArgumentException(
                    "The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(v1.toString());
        BigDecimal b2 = new BigDecimal(v2.toString());
        return b1.divide(b2,scale,BigDecimal.ROUND_HALF_UP).doubleValue();
    }}
