package com.bxm.datapark.facade.activity;

import com.bxm.util.dto.ResultModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 用于活动定时任务
 * @author bcc
 */
@FeignClient(name="datapark")
public interface ActivityCountForTimerService {

    /**
     * 获取大盘优秀活动
     * @param dto
     * @return
     */
    @RequestMapping(value = "/goodActivityStatistic",method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<Long>> goodActivityStatistic(@RequestBody GoodActivityStatisticDto dto);

    /**
     * 统计广告位各活动UV
     * @param datetime
     * @return
     */
    @RequestMapping(value = "/queryActivityForActivitiesTimer",method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<ActivityCountForTimerVo>> queryActivityForActivitiesTimer(@RequestParam("datetime") String datetime);

    /**
     * 统计广告位活动首页UV汇总
     * @param datetime
     * @return
     */
    @RequestMapping(value = "/queryPositionActivityForActivitiesTimer",method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<ActivityCountForTimerVo>> queryPositionActivityForActivitiesTimer(@RequestParam("datetime") String datetime);

}
