package com.bxm.datapark.facade.activity;

import org.springframework.data.mongodb.core.mapping.Field;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by wuwenquan on 2018/6/22.
 */
public class ActivityReportVo implements Serializable {
    /**
     * 日期
     */
    @Field("pt")
    private Date pt;

    private String datetime;

    /**
     * 开发者名称
     */
    @Field("appname")
    private String appName;


    /**
     * 开发者标志
     */
    @Field("appkey")
    private String appKey;

    /**
     * 广告位id
     */
    @Field("positionid")
    private String  positionId;

    /**
     * 广告位名称
     */
    @Field("entrancename")
    private  String  positionName;

    /**
     * 活动id
     */
    @Field("activityid")
    private Long  activityId;

    /**
     * 活动名称
     */
    @Field("activityname")
    private String  activityName;

    /**
     * 活动类型名称
     */
    @Field("activitytype_name")
    private String  activityTypeName;

    /**
     * 活动首页pv
     */
    @Field("index_pv")
    private Integer  indexPv;

    /**
     *活动首页uv
     */
    @Field("index_uv")
    private  Integer indexUv;

    /**
     * 参与次数
     */
    @Field("join_pv")
    private  Integer   joinPv;

    /**
     * 参与人数
     */
    @Field("join_uv")
    private Integer joinUv;

    /**
     * 参与率
     */
    @Field("join_rate")
    private double  joinRate;
    private String  joinRateShow;

    /**
     * 人均发券
     */
    @Field("per_open_pv")
    private double  perOpenPv;

    /**
     * 重复发券
     */
    @Field("rpt_open_pv")
    private double  rptOpenPv;

    /**
     * 发券量
     */
    @Field("open_pv")
    private Integer  openPv;

    /**
     * 发券成功率
     */
    @Field("success_rate")
    private double successRate;
    private String successRateShow;

    /**
     * 点击量
     */
    @Field("click_pv")
    private Integer  clickPv;

    /**
     * 点击率
     */
    @Field("click_rate")
    private double  clickRate;
    private String  clickRateShow;

    /**
     * 人均券点击
     */
    @Field("per_click_pv")
    private double  perClickPv;

    /**
     * 发券请求
     */
    @Field("send_pv")
    private Integer  sendPv;

    /**
     * 活动标签
     * */
    @Field("activitytag")
    private String activityTag;
    private String activityTagShow;

    public String getActivityTagShow() {
        return activityTagShow;
    }

    public void setActivityTagShow(String activityTagShow) {
        this.activityTagShow = activityTagShow;
    }

    public String getActivityTag() {
        return activityTag;
    }

    public void setActivityTag(String activityTag) {
        this.activityTag = activityTag;
    }

    public String getJoinRateShow() {

        return    (Double)joinRate!=null?(joinRate+"%"):null;
    }

    public String getSuccessRateShow() {
        return (Double)successRate!=null?(successRate+"%"):null;
    }

    public String getClickRateShow() {
        return (Double)clickRate!=null?(clickRate+"%"):null;
    }

    public Integer getSendPv() {
        return sendPv;
    }

    public void setSendPv(Integer sendPv) {
        this.sendPv = sendPv;
    }

    public Date getPt() {
        return pt;
    }

    public void setPt(Date pt) {
        this.pt = pt;
    }

    public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public String getActivityPlanName() {
        return activityPlanName;
    }

    public void setActivityPlanName(String activityPlanName) {
        this.activityPlanName = activityPlanName;
    }

    /**
     * 活动策划名称
     */
    @Field("activityplan_name")

    private String  activityPlanName;

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getPositionName() {
        return positionName;
    }

    public void setPositionName(String positionName) {
        this.positionName = positionName;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getActivityTypeName() {
        return activityTypeName;
    }

    public void setActivityTypeName(String activityTypeName) {
        this.activityTypeName = activityTypeName;
    }

    public Integer getIndexPv() {
        return indexPv;
    }

    public void setIndexPv(Integer indexPv) {
        this.indexPv = indexPv;
    }

    public Integer getIndexUv() {
        return indexUv;
    }

    public void setIndexUv(Integer indexUv) {
        this.indexUv = indexUv;
    }

    public Integer getJoinPv() {
        return joinPv;
    }

    public void setJoinPv(Integer joinPv) {
        this.joinPv = joinPv;
    }

    public Integer getJoinUv() {
        return joinUv;
    }

    public void setJoinUv(Integer joinUv) {
        this.joinUv = joinUv;
    }

    public double getJoinRate() {
        return joinRate;
    }

    public void setJoinRate(double joinRate) {
        this.joinRate = joinRate;
    }

    public double getPerOpenPv() {
        return perOpenPv;
    }

    public void setPerOpenPv(double perOpenPv) {
        this.perOpenPv = perOpenPv;
    }

    public double getRptOpenPv() {
        return rptOpenPv;
    }

    public void setRptOpenPv(double rptOpenPv) {
        this.rptOpenPv = rptOpenPv;
    }

    public Integer getOpenPv() {
        return openPv;
    }

    public void setOpenPv(Integer openPv) {
        this.openPv = openPv;
    }

    public double getSuccessRate() {
        return successRate;
    }

    public void setSuccessRate(double successRate) {
        this.successRate = successRate;
    }

    public Integer getClickPv() {
        return clickPv;
    }

    public void setClickPv(Integer clickPv) {
        this.clickPv = clickPv;
    }

    public double getClickRate() {
        return clickRate;
    }

    public void setClickRate(double clickRate) {
        this.clickRate = clickRate;
    }

    public double getPerClickPv() {
        return perClickPv;
    }

    public void setPerClickPv(double perClickPv) {
        this.perClickPv = perClickPv;
    }
}
