/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.datapark.facade.ticket.service;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.ticket.model.dto.AppBusinessTicketDto;
import com.bxm.datapark.facade.ticket.model.dto.SendTicketDetailDto;
import com.bxm.datapark.facade.ticket.model.dto.SendTicketDto;
import com.bxm.datapark.facade.ticket.model.dto.TicketUrlDto;
import com.bxm.datapark.facade.ticket.model.vo.SendTicketDetailVo;
import com.bxm.datapark.facade.ticket.model.vo.SendTicketVo;
import com.bxm.datapark.facade.ticket.model.vo.TicketCountCommonVo;
import com.bxm.datapark.facade.ticket.model.vo.TicketUrlVo;
import com.bxm.util.dto.ResultModel;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="datapark")
public interface TicketDataReportSevice {
    @RequestMapping(value={"/ticket"}, method={RequestMethod.POST}, consumes={"application/json"})
    public ResultModel<Page<TicketCountCommonVo>> ticketReport(@RequestBody AppBusinessTicketDto var1);

    @RequestMapping(value={"/ticket/export"}, method={RequestMethod.POST}, consumes={"application/json"})
    public ResultModel<List<TicketCountCommonVo>> ticketReportExport(@RequestBody AppBusinessTicketDto var1);

    @RequestMapping(value={"/ticket/date"}, method={RequestMethod.POST}, consumes={"application/json"})
    public ResultModel<List<TicketCountCommonVo>> ticketDateReport(@RequestBody AppBusinessTicketDto var1);

    @RequestMapping(value={"/ticket/hour"}, method={RequestMethod.POST}, consumes={"application/json"})
    public ResultModel<Page<TicketCountCommonVo>> ticketHourReport(@RequestBody AppBusinessTicketDto var1);

    @RequestMapping(value={"/ticket/hour/export"}, method={RequestMethod.POST}, consumes={"application/json"})
    public ResultModel<List<TicketCountCommonVo>> ticketHourReportExport(@RequestBody AppBusinessTicketDto var1);

    @RequestMapping(value={"/ticketurl/list"}, method={RequestMethod.POST}, consumes={"application/json"})
    public ResultModel<Page<TicketUrlVo>> analysisTicketUrl(@RequestBody TicketUrlDto var1);

    @RequestMapping(value={"/report/sendticket/compare"}, method={RequestMethod.POST}, consumes={"application/json"})
    public ResultModel<Page<SendTicketVo>> getTicketCompare(@RequestBody SendTicketDto var1);

    @RequestMapping(value={"/report/sendticket/compareDetail"}, method={RequestMethod.POST}, consumes={"application/json"})
    public ResultModel<Page<SendTicketDetailVo>> getTicketCompareDetail(@RequestBody SendTicketDetailDto var1);

    @GetMapping(value={"/spare/certificate"})
    public void spareCertificate(@RequestParam(name="datetime") String var1);

    @GetMapping(value={"/spare/certificate/hour"})
    public void spareCertificateForHour(@RequestParam(name="datetime") String var1, @RequestParam(name="hour", required=false) Integer var2);

    @PostMapping(value={"/advertiser/ticket/date"})
    public ResultModel<List<TicketCountCommonVo>> selectTicketCount(@RequestBody AppBusinessTicketDto var1);

    @PostMapping(value={"/advertiser/ticket/app/business"})
    public ResultModel<List<TicketCountCommonVo>> selectTicketCountByTicketId(@RequestBody AppBusinessTicketDto var1);
}

